/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import net.jitl.common.block.JChestBlock;
import net.jitl.common.items.base.JItem;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ChestInteractionItem
extends JItem {
    public ChestInteractionItem() {
        super(JItems.itemProps().m_41487_(16));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        assert (player != null);
        ItemStack heldItem = player.m_21205_();
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(pos = context.m_8083_());
        if (blockstate.m_60734_() instanceof JChestBlock) {
            this.unlockChest(player, (Item)JItems.CHEST_KEY.get(), world, pos, (Block)JBlocks.BOIL_CHEST.get(), (Block)JBlocks.EUCA_CHEST.get(), (Block)JBlocks.FROZEN_CHEST.get(), (Block)JBlocks.NETHER_CHEST.get(), (Block)JBlocks.JOURNEY_CHEST.get(), (Block)JBlocks.DEPTHS_CHEST.get(), (Block)JBlocks.CORBA_CHEST.get(), (Block)JBlocks.TERRANIAN_CHEST.get(), (Block)JBlocks.CLOUDIA_CHEST.get(), (Block)JBlocks.SENTERIAN_CHEST.get());
            this.unlockChest(player, (Item)JItems.BOILING_KEY.get(), world, pos, (Block)JBlocks.BOIL_CHEST.get());
            this.unlockChest(player, (Item)JItems.EUCA_KEY.get(), world, pos, (Block)JBlocks.EUCA_CHEST.get());
            this.unlockChest(player, (Item)JItems.FROZEN_KEY.get(), world, pos, (Block)JBlocks.FROZEN_CHEST.get());
            this.unlockChest(player, (Item)JItems.NETHER_KEY.get(), world, pos, (Block)JBlocks.NETHER_CHEST.get());
            this.unlockChest(player, (Item)JItems.JOURNEY_KEY.get(), world, pos, (Block)JBlocks.JOURNEY_CHEST.get());
            this.unlockChest(player, (Item)JItems.DEPTHS_CHEST_KEY.get(), world, pos, (Block)JBlocks.DEPTHS_CHEST.get());
            this.unlockChest(player, (Item)JItems.CORBA_KEY.get(), world, pos, (Block)JBlocks.CORBA_CHEST.get());
            this.unlockChest(player, (Item)JItems.TERRANIAN_KEY.get(), world, pos, (Block)JBlocks.TERRANIAN_CHEST.get());
            this.unlockChest(player, (Item)JItems.CLOUDIA_KEY.get(), world, pos, (Block)JBlocks.CLOUDIA_CHEST.get());
            this.unlockChest(player, (Item)JItems.SENTERIAN_KEY.get(), world, pos, (Block)JBlocks.SENTERIAN_CHEST.get());
            if (heldItem.m_41720_() == JItems.PADLOCK.get()) {
                this.lockChest(player, world, pos);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public void lockChest(Player player, Level world, BlockPos pos) {
        BlockState clickedChest = world.m_8055_(pos);
        Block chest = clickedChest.m_60734_();
        if (world.m_8055_(pos).m_60734_() == chest) {
            boolean isWest;
            BlockState n = world.m_8055_(pos.m_122012_());
            BlockState s = world.m_8055_(pos.m_122019_());
            BlockState e = world.m_8055_(pos.m_122029_());
            BlockState w = world.m_8055_(pos.m_122024_());
            boolean isNorth = n.m_60734_() == chest;
            boolean isSouth = s.m_60734_() == chest;
            boolean isEast = e.m_60734_() == chest;
            boolean bl = isWest = w.m_60734_() == chest;
            if (!((Boolean)clickedChest.m_61143_((Property)JChestBlock.IS_LOCKED)).booleanValue()) {
                world.m_7731_(pos, (BlockState)clickedChest.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                if (isNorth) {
                    world.m_7731_(pos.m_122012_(), (BlockState)n.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                if (isSouth) {
                    world.m_7731_(pos.m_122019_(), (BlockState)s.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                if (isEast) {
                    world.m_7731_(pos.m_122029_(), (BlockState)e.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                if (isWest) {
                    world.m_7731_(pos.m_122024_(), (BlockState)w.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                player.m_21205_().m_41774_(1);
                world.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void unlockChest(Player player, Item key, Level world, BlockPos pos, Block ... c) {
        for (Block chest : c) {
            if (player.m_21205_().m_41720_() != key || world.m_8055_(pos).m_60734_() != chest) continue;
            BlockState n = world.m_8055_(pos.m_122012_());
            BlockState s = world.m_8055_(pos.m_122019_());
            BlockState e = world.m_8055_(pos.m_122029_());
            BlockState w = world.m_8055_(pos.m_122024_());
            boolean isNorth = n.m_60734_() == chest;
            boolean isSouth = s.m_60734_() == chest;
            boolean isEast = e.m_60734_() == chest;
            boolean isWest = w.m_60734_() == chest;
            BlockState clickedChest = world.m_8055_(pos);
            if (!((Boolean)clickedChest.m_61143_((Property)JChestBlock.IS_LOCKED)).booleanValue()) continue;
            world.m_7731_(pos, (BlockState)clickedChest.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            if (isNorth) {
                world.m_7731_(pos.m_122012_(), (BlockState)n.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            if (isSouth) {
                world.m_7731_(pos.m_122019_(), (BlockState)s.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            if (isEast) {
                world.m_7731_(pos.m_122029_(), (BlockState)e.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            if (isWest) {
                world.m_7731_(pos.m_122024_(), (BlockState)w.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            player.m_21205_().m_41774_(1);
            world.m_5594_(null, pos, SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void checkSpecificKeyToChest(Player player, Item key, Block chest, BlockState blockstate, Level world, BlockPos pos) {
        if (player.m_21205_().m_41720_() == key && blockstate.m_60734_() == chest && ((Boolean)blockstate.m_61143_((Property)JChestBlock.IS_LOCKED)).booleanValue()) {
            BlockState s = (BlockState)blockstate.m_61124_((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE);
            world.m_7731_(pos, s, 2);
            player.m_21205_().m_41774_(1);
            world.m_5594_(null, pos, SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

