/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.TriFunction;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GunItem
extends JItem
implements IEssenceItem {
    protected TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory;
    private final int essenceUsage;
    private final int damage;

    public GunItem(int essence, int damage, int maxUses, TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory) {
        super(JItems.itemProps().m_41487_(1).m_41503_(maxUses));
        this.projectileFactory = projectileFactory;
        this.essenceUsage = essence;
        this.damage = damage;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (worldIn instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)worldIn;
                if ((double)GunItem.getPowerForTime(this.m_8105_(stack) - timeLeft) > 0.25) {
                    player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(essence -> {
                        if (essence.consumeEssence(player, this.essenceUsage)) {
                            JThrowableProjectile projectile = this.projectileFactory.apply(this.damage, (Level)level, (LivingEntity)player);
                            projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                            level.m_7967_((Entity)projectile);
                            player.m_21120_(player.m_7655_()).m_41622_(1, (LivingEntity)player, item -> {});
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JSounds.CANNON.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                        }
                    });
                }
            }
        }
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack item) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"jitl.tooltip.cannon", (Object[])new Object[]{this.damage / 2}));
        this.addItemDesc(((Item)JItems.NETHER_PLASMA.get()).m_5456_(), tooltip, "jitl.tooltip.nether_plasma");
        this.addItemDesc(((Item)JItems.OCEAN_PLASMA.get()).m_5456_(), tooltip, "jitl.tooltip.ocean_plasma");
        this.addItemDesc(((Item)JItems.FOREST_PLASMA.get()).m_5456_(), tooltip, "jitl.tooltip.forest_plasma");
        this.addItemDesc(((Item)JItems.ROCK_LAUNCHER.get()).m_5456_(), tooltip, "jitl.tooltip.rock_launcher");
        this.addItemDesc(((Item)JItems.CHAOS_CANNON.get()).m_5456_(), tooltip, "jitl.tooltip.chaos_cannon");
        this.addItemDesc(((Item)JItems.EYE_BLASTER.get()).m_5456_(), tooltip, "jitl.tooltip.eye_blaster");
        tooltip.add((Component)Component.m_237110_((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
        tooltip.add((Component)Component.m_237110_((String)"jitl.uses_remaining", (Object[])new Object[]{stack.m_41776_() - stack.m_41773_()}));
    }
}

