/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.jitl.common.items.base.JItem;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class LootItem
extends JItem {
    public LootTier tier;

    public LootItem(LootTier tier) {
        super(JItems.itemProps().m_41487_(4));
        this.tier = tier;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @NotNull Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        RandomSource rand = world.f_46441_;
        String lootName = "";
        switch (this.tier) {
            case NORMAL: {
                lootName = "basic";
                break;
            }
            case GOLD: {
                lootName = "gold";
                break;
            }
            case DIAMOND: {
                lootName = "diamond";
                break;
            }
            case FROSTY_GIFT: {
                lootName = "frosty_gift";
            }
        }
        if (!world.f_46443_) {
            LootTable table = Objects.requireNonNull(world.m_7654_()).m_278653_().m_278676_(JITL.rl("loot/loot_" + lootName));
            ObjectArrayList itemList = table.m_287195_(new LootParams.Builder((ServerLevel)world).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81416_));
            ItemStack spawn = (ItemStack)itemList.get(rand.m_188503_(itemList.size()));
            ItemEntity item = new ItemEntity(world, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, spawn);
            world.m_7967_((Entity)item);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public Rarity m_41460_(ItemStack p_41461_) {
        Rarity r = Rarity.COMMON;
        switch (this.tier) {
            case NORMAL: 
            case FROSTY_GIFT: {
                r = Rarity.UNCOMMON;
                break;
            }
            case GOLD: {
                r = Rarity.RARE;
                break;
            }
            case DIAMOND: {
                r = Rarity.EPIC;
            }
        }
        return r;
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return this.tier == LootTier.DIAMOND;
    }

    public static enum LootTier {
        NORMAL,
        GOLD,
        DIAMOND,
        FROSTY_GIFT;

    }
}

