/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.TriFunction;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaffItem
extends JItem
implements IEssenceItem {
    protected TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory;
    private final int essenceUsage;
    private final int damage;

    public StaffItem(int essence, int damage, int maxUses, TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory) {
        super(JItems.itemProps().m_41487_(1).m_41503_(maxUses));
        this.projectileFactory = projectileFactory;
        this.essenceUsage = essence;
        this.damage = damage;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.m_5776_()) {
            player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(essence -> {
                if (essence.consumeEssence(player, this.essenceUsage)) {
                    JThrowableProjectile projectile = this.projectileFactory.apply(this.damage, level, (LivingEntity)player);
                    projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                    level.m_7967_((Entity)projectile);
                    player.m_21120_(player.m_7655_()).m_41622_(1, (LivingEntity)player, item -> {});
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JSounds.STAFF_0.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                }
            });
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"jitl.tooltip.staff", (Object[])new Object[]{this.damage / 2}));
        this.addItemDesc(((Item)JItems.STAFF_OF_CONJURING.get()).m_5456_(), tooltip, "jitl.tooltip.staff_of_conjuring");
        this.addItemDesc(((Item)JItems.STAFF_OF_ESSENCIA.get()).m_5456_(), tooltip, "jitl.tooltip.staff_of_essencia");
        this.addItemDesc(((Item)JItems.STAFF_OF_HELLSTONE.get()).m_5456_(), tooltip, "jitl.tooltip.staff_of_hellstone");
        this.addItemDesc(((Item)JItems.DOOMSBRINGER.get()).m_5456_(), tooltip, "jitl.tooltip.doomsbringer");
        this.addItemDesc(((Item)JItems.OVERGROWN_STAFF.get()).m_5456_(), tooltip, "jitl.tooltip.overgrown_staff");
        this.addItemDesc(((Item)JItems.STAFF_OF_DIVINITY.get()).m_5456_(), tooltip, "jitl.tooltip.staff_of_divinity");
        this.addItemDesc(((Item)JItems.STAFF_OF_ENLIGHTENMENT.get()).m_5456_(), tooltip, "jitl.tooltip.staff_of_enlightenment");
        this.addItemDesc(((Item)JItems.CRYSTAL_STAFF.get()).m_5456_(), tooltip, "jitl.tooltip.crystal_staff");
        this.addItemDesc(((Item)JItems.STAFF_OF_GREENPACE.get()).m_5456_(), tooltip, "jitl.tooltip.staff_of_greenpace");
        tooltip.add((Component)Component.m_237110_((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
        tooltip.add((Component)Component.m_237110_((String)"jitl.uses_remaining", (Object[])new Object[]{stack.m_41776_() - stack.m_41773_()}));
    }
}

