/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.MathHelper;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TeleportItem
extends JItem
implements IEssenceItem {
    private final int essenceUsage;

    public TeleportItem(int essence, int maxUses) {
        super(JItems.itemProps().m_41487_(1).m_41503_(maxUses));
        this.essenceUsage = essence;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        float var18;
        float var16;
        double var19;
        float var15;
        float var4 = player.m_146909_();
        float var5 = player.m_146908_();
        double var6 = player.m_20185_();
        double var8 = player.m_20186_() + 1.62;
        double var10 = player.m_20189_();
        Vec3 var12 = new Vec3(var6, var8, var10);
        float var13 = MathHelper.cos(-var5 * 0.01745329f - (float)Math.PI);
        float var14 = MathHelper.sin(-var5 * 0.01745329f - (float)Math.PI);
        float var17 = var14 * (var15 = -MathHelper.cos(-var4 * 0.01745329f));
        Vec3 var21 = var12.m_82520_((double)var17 * (var19 = 30.0), (double)(var16 = MathHelper.sin(-var4 * 0.01745329f)) * var19, (double)(var18 = var13 * var15) * var19);
        BlockHitResult var22 = level.m_45547_(new ClipContext(var12, var21, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        if (var22 == null) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(usedHand));
        }
        int var23 = var22.m_82425_().m_123341_();
        int var24 = var22.m_82425_().m_123342_();
        int var25 = var22.m_82425_().m_123343_();
        Direction var26 = var22.m_82434_();
        if (var26 == Direction.DOWN) {
            --var24;
        }
        if (var26 == Direction.UP) {
            ++var24;
        }
        if (var26 == Direction.NORTH) {
            --var25;
        }
        if (var26 == Direction.SOUTH) {
            ++var25;
        }
        if (var26 == Direction.WEST) {
            --var23;
        }
        if (var26 == Direction.EAST) {
            ++var23;
        }
        if (!level.m_5776_()) {
            int finalVar2 = var23;
            int finalVar3 = var24;
            int finalVar4 = var25;
            player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(essence -> {
                if (essence.consumeEssence(player, this.essenceUsage)) {
                    this.teleportTo((ServerPlayer)player, level, finalVar2, finalVar3 + 1, finalVar4);
                    player.m_21120_(player.m_7655_()).m_41622_(1, (LivingEntity)player, item -> {});
                }
            });
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
    }

    protected void teleportTo(ServerPlayer player, Level level, int x, int y, int z) {
        player.m_6021_((double)x, (double)y, (double)z);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        this.addItemDesc(((Item)JItems.TELEPORTATION_STAFF.get()).m_5456_(), tooltip, "jitl.tooltip.teleport");
        tooltip.add((Component)Component.m_237110_((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
    }
}

