/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.entity.projectile.EssenceArrowEntity;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JTags;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class JBowItem
extends BowItem {
    public static final int DEFAULT_DURATION = 72000;
    protected int maxUseDuration;
    protected float damage;
    protected Item arrow_item;
    protected int uses;
    protected int essence_use;
    public EnumSet<EssenceArrowEntity.BowEffects> effect;
    public static final Predicate<ItemStack> ESSENCE_ARROW = tag -> tag.m_204117_(JTags.ESSENCE_ARROW);

    public JBowItem(float damage, int uses, EnumSet<EssenceArrowEntity.BowEffects> effect, int pullbackSpeed) {
        super(JItems.itemProps().m_41487_(1).m_41503_(uses));
        this.effect = effect;
        this.arrow_item = (Item)JItems.ESSENCE_ARROW.get();
        this.damage = damage;
        this.uses = uses;
        this.maxUseDuration = pullbackSpeed;
    }

    public JBowItem setEssenceUse(int amount) {
        this.essence_use = amount;
        return this;
    }

    public float getScaledArrowVelocity(int charge) {
        float timeRatio = 72000.0f / (float)this.maxUseDuration;
        float f = (float)charge / 20.0f * timeRatio;
        if ((f = (f * f + f * 2.0f) / 2.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            boolean emptyPickup = player.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0 || this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE);
            ItemStack itemstack = this.findAmmo(player);
            int i = this.maxUseDuration - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)player, (int)i, (!itemstack.m_41619_() || emptyPickup ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || emptyPickup) {
                float f;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)this.arrow_item);
                }
                if ((double)(f = this.getScaledArrowVelocity(i)) >= 0.1) {
                    if (!worldIn.f_46443_) {
                        EssenceArrowEntity entityarrow = null;
                        EssenceArrowEntity entityarrow2 = null;
                        try {
                            entityarrow = new EssenceArrowEntity(worldIn, (LivingEntity)player, this.effect, this.damage);
                            entityarrow2 = new EssenceArrowEntity(worldIn, (LivingEntity)player, this.effect, this.damage);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.DOUBLE_ARROW)) {
                            int k;
                            assert (entityarrow != null);
                            entityarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + 3.25f, 0.0f, f * 3.0f, 1.0f);
                            assert (entityarrow2 != null);
                            entityarrow2.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() - 3.25f, 0.0f, f * 3.0f, 1.0f);
                            int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                            if ((float)j == 1.0f) {
                                entityarrow.m_36762_(true);
                                entityarrow2.m_36762_(true);
                            }
                            if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                                entityarrow.m_36735_(k);
                                entityarrow2.m_36735_(k);
                            }
                            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                                entityarrow.m_20254_(100);
                                entityarrow2.m_20254_(100);
                            }
                            entityarrow.m_36781_(this.damage);
                            entityarrow2.m_36781_(this.damage);
                            stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(player.m_7655_()));
                            if (!emptyPickup) {
                                entityarrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                                entityarrow2.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                            } else {
                                entityarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                                entityarrow2.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                            }
                            worldIn.m_7967_((Entity)entityarrow);
                            worldIn.m_7967_((Entity)entityarrow2);
                        } else {
                            int k;
                            assert (entityarrow != null);
                            entityarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 1.0f);
                            int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                            if ((float)j == 1.0f) {
                                entityarrow.m_36762_(true);
                            }
                            if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                                entityarrow.m_36735_(k);
                            }
                            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                                entityarrow.m_20254_(100);
                            }
                            entityarrow.m_36781_(this.damage);
                            stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(player.m_7655_()));
                            entityarrow.f_36705_ = !emptyPickup ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY;
                            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                                EssenceArrowEntity finalEntityarrow = entityarrow;
                                player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(essence -> {
                                    if (essence.consumeEssence(player, this.essence_use)) {
                                        worldIn.m_7967_((Entity)finalEntityarrow);
                                    }
                                });
                            }
                            if (!this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                                worldIn.m_7967_((Entity)entityarrow);
                            }
                        }
                    }
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!emptyPickup) {
                        if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.DOUBLE_ARROW)) {
                            itemstack.m_41774_(2);
                        } else {
                            itemstack.m_41774_(1);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public ItemStack findAmmo(Player player) {
        if (this.isArrow(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isArrow(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < player.f_36095_.m_38927_().size(); ++i) {
            ItemStack itemstack = (ItemStack)player.f_36095_.m_38927_().get(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comp, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, comp, isAdvanced);
        comp.add((Component)Component.m_237115_((String)("Damage: " + ChatFormatting.GOLD + this.damage + " - " + ChatFormatting.GOLD + this.damage * 4.0f)));
        float maxUse = 72000.0f / (float)this.maxUseDuration;
        DecimalFormat df = new DecimalFormat("#.##");
        comp.add((Component)Component.m_237115_((String)("Pull Back Speed: " + ChatFormatting.GOLD + df.format(maxUse))));
        if (this.effect != null) {
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.WITHER)) {
                comp.add((Component)Component.m_237115_((String)(ChatFormatting.DARK_GRAY + "Ability: Withers foe")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.FLAME)) {
                comp.add((Component)Component.m_237115_((String)(ChatFormatting.GOLD + "Ability: Sets foe ablaze")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.POISON)) {
                comp.add((Component)Component.m_237115_((String)(ChatFormatting.GREEN + "Ability: Poisons foe")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.SLOWNESS)) {
                comp.add((Component)Component.m_237115_((String)(ChatFormatting.BLUE + "Ability: Stuns foe")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.DOUBLE_ARROW)) {
                comp.add((Component)Component.m_237115_((String)(ChatFormatting.BLUE + "Ability: Shoots 2 arrows")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                comp.add((Component)Component.m_237115_((String)(ChatFormatting.GREEN + "Ability: Consumes " + this.essence_use + " Essence instead of arrows")));
            }
        }
        comp.add((Component)Component.m_237115_((String)("Uses remaining: " + ChatFormatting.GRAY + this.uses)));
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return ESSENCE_ARROW;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return this.maxUseDuration;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.m_41720_() == JItems.ESSENCE_ARROW.get();
    }
}

