/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jitl.core.helper.JToolTiers;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class MultitoolItem
extends DiggerItem {
    private final TagKey<Block> shovel = BlockTags.f_144283_;
    private final TagKey<Block> axe = BlockTags.f_144280_;
    private final TagKey<Block> pick = BlockTags.f_144282_;
    private final TagKey<Block> hoe = BlockTags.f_144281_;

    public MultitoolItem(JToolTiers tier) {
        super((float)(tier.getDamage() - 2), tier.getSpeedModifier(), tier.getTier(), BlockTags.f_144280_, JItems.itemProps());
    }

    public static Consumer<UseOnContext> changeIntoState(BlockState pState) {
        return l -> {
            l.m_43725_().m_7731_(l.m_8083_(), pState, 11);
            l.m_43725_().m_220407_(GameEvent.f_157792_, l.m_8083_(), GameEvent.Context.m_223719_((Entity)l.m_43723_(), (BlockState)pState));
        };
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Pair pair;
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (pContext.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = pContext.m_43723_();
        BlockState blockstate1 = blockstate.getToolModifiedState(pContext, ToolActions.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (blockstate1 != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_((Entity)pContext.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.FALSE);
        }
        if (blockstate2 != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, blockstate2, 11);
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate2));
                if (player != null) {
                    pContext.m_43722_().m_41622_(1, (LivingEntity)player, p_43122_ -> p_43122_.m_21190_(pContext.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockState toolModifiedState = level.m_8055_(blockpos).getToolModifiedState(pContext, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, MultitoolItem.changeIntoState(toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(pContext)) {
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(pContext);
                if (player != null) {
                    pContext.m_43722_().m_41622_(1, (LivingEntity)player, l -> l.m_21190_(pContext.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction);
    }

    private boolean isMineable(BlockState s) {
        return s.m_204336_(this.shovel) || s.m_204336_(this.axe) || s.m_204336_(this.pick) || s.m_204336_(this.hoe);
    }

    public float m_8102_(@NotNull ItemStack pStack, @NotNull BlockState pState) {
        return this.isMineable(pState) ? this.f_40980_ : 1.0f;
    }

    public boolean m_7579_(ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, l -> l.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(@NotNull ItemStack pStack, Level pLevel, @NotNull BlockState pState, @NotNull BlockPos pPos, @NotNull LivingEntity pEntityLiving) {
        if (!pLevel.f_46443_ && pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(1, pEntityLiving, l -> l.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(@NotNull BlockState pBlock) {
        if (TierSortingRegistry.isTierSorted((Tier)this.m_43314_())) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)pBlock) && this.isMineable(pBlock);
        }
        int i = this.m_43314_().m_6604_();
        if (i < 3 && pBlock.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (i < 2 && pBlock.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return (i >= 1 || !pBlock.m_204336_(BlockTags.f_144286_)) && this.isMineable(pBlock);
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, @NotNull BlockState state) {
        return this.isMineable(state) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }
}

