/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.curios;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.TooltipFiller;
import net.jitl.core.init.JITL;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class JCurioItem
extends JItem
implements ICurioItem {
    private boolean hasOverview;
    private boolean hasAbility;
    private boolean hasNegativeEffects;

    public JCurioItem(Item.Properties properties) {
        super(properties);
    }

    public JCurioItem overview(boolean hasOverview) {
        this.hasOverview = hasOverview;
        return this;
    }

    public JCurioItem ability(boolean hasAbility) {
        this.hasAbility = hasAbility;
        return this;
    }

    public JCurioItem drawback(boolean hasNegativeEffects) {
        this.hasNegativeEffects = hasNegativeEffects;
        return this;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> text, @NotNull TooltipFlag flag) {
        TooltipFiller tooltipFiller = new TooltipFiller(text, Objects.requireNonNull(JITL.getRegistryName(this)).m_135815_());
        if (this.hasOverview) {
            tooltipFiller.addOverview();
        }
        if (this.hasAbility) {
            tooltipFiller.addDetail();
        }
        if (this.hasNegativeEffects) {
            tooltipFiller.addDrawback();
        }
    }
}

