/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.gear;

import java.util.List;
import net.jitl.common.items.gear.FullArmorAbility;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public interface IAbility {
    default public void tick(LivingEntity entity, Level world, ItemStack stack) {
    }

    default public void attackTarget(LivingEntity attacker, ItemStack stack, LivingHurtEvent event) {
    }

    default public void damageTarget(LivingEntity holder, ItemStack stack, LivingDamageEvent event) {
    }

    default public void rightClick(Player player, InteractionHand hand, Level world) {
    }

    default public void breakBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
    }

    default public float blockBreakSpeed(ItemStack stack, BlockState state, float original) {
        return original;
    }

    default public boolean isCorrectTool(ItemStack stack, BlockState state) {
        Item item = stack.m_41720_();
        return item.m_8096_(state);
    }

    default public void equip(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
    }

    default public void unEquip(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
    }

    default public void fillTooltips(ItemStack stack, List<Component> tooltip) {
    }

    default public boolean animate(boolean original, ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return original;
    }

    default public FullArmorAbility getFullAbility(CompoundTag nbt) {
        return null;
    }

    default public boolean resetBreak(boolean original, ItemStack oldStack, ItemStack newStack) {
        return original;
    }

    public static interface INBTUpdateAbility
    extends IAbility {
        @Override
        default public boolean animate(boolean original, ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
            if (oldStack.equals(newStack)) {
                return false;
            }
            if (oldStack.m_150930_(newStack.m_41720_())) {
                int durability = oldStack.m_41773_() - newStack.m_41773_();
                return durability != 0 && durability != 1;
            }
            return true;
        }

        @Override
        default public boolean resetBreak(boolean original, ItemStack oldStack, ItemStack newStack) {
            if (oldStack.equals(newStack)) {
                return false;
            }
            if (oldStack.m_150930_(newStack.m_41720_())) {
                int durability = oldStack.m_41773_() - newStack.m_41773_();
                return durability != 0 && durability != 1;
            }
            return true;
        }

        @Override
        default public void equip(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
        }
    }
}

