/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.gear.korite;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.items.gear.IAbility;
import net.jitl.core.helper.TooltipFiller;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class KoriteSwordAbility
implements IAbility {
    private static final UUID ID = UUID.fromString("cb129eb4-c625-4a9a-b778-00176b83610d");

    @Override
    public void attackTarget(LivingEntity attacker, ItemStack stack, LivingHurtEvent event) {
        if (stack.m_41782_()) {
            Objects.requireNonNull(attacker.m_21051_(Attributes.f_22281_)).m_22120_(ID);
            if (stack.m_41783_() != null) {
                stack.m_41783_().m_128350_("bonus", 0.0f);
            }
        }
    }

    @Override
    public void rightClick(Player player, InteractionHand hand, Level world) {
        if (!world.m_5776_() && hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21205_();
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            CompoundTag nbt = stack.m_41783_();
            player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(essence -> {
                float bonus = Math.min(essence.getCurrentEssence(), 5.0f);
                if (nbt != null && nbt.m_128457_("bonus") < bonus && essence.consumeEssence(player, bonus)) {
                    nbt.m_128350_("bonus", bonus);
                    this.addModifier((LivingEntity)player, bonus);
                }
            });
        }
    }

    @Override
    public void equip(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        float bonus;
        if (slot == EquipmentSlot.MAINHAND && stack.m_41782_() && stack.m_41783_() != null && (bonus = stack.m_41783_().m_128457_("bonus")) > 0.0f) {
            this.addModifier(entity, bonus);
        }
    }

    @Override
    public void unEquip(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            Objects.requireNonNull(entity.m_21051_(Attributes.f_22281_)).m_22120_(ID);
        }
    }

    @Override
    public void fillTooltips(ItemStack stack, List<Component> tooltip) {
        TooltipFiller filler = new TooltipFiller(tooltip, "korite_sword");
        filler.addOverview();
        filler.addDrawback();
        filler.addBreak();
        assert (stack.m_41783_() != null);
        filler.addValue(Math.floor(stack.m_41783_().m_128457_("bonus") * 100.0f) / 100.0);
    }

    private void addModifier(LivingEntity entity, float value) {
        AttributeInstance attribute = entity.m_21051_(Attributes.f_22281_);
        if (attribute != null) {
            attribute.m_22120_(ID);
            attribute.m_22118_(new AttributeModifier(ID, "Korite sword", (double)value, AttributeModifier.Operation.ADDITION));
        }
    }
}

