/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world;

import java.util.Objects;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.capability.gear.PlayerArmor;
import net.jitl.common.capability.gear.PlayerArmorProvider;
import net.jitl.common.capability.keypressed.PressedKeyCap;
import net.jitl.common.capability.keypressed.PressedKeyCapProvider;
import net.jitl.common.capability.portal.PlayerPortal;
import net.jitl.common.capability.portal.PlayerPortalProvider;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.jitl.core.init.internal.JAttributes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jitl", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    public static void onPlayerAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (!player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).isPresent()) {
                event.addCapability(new ResourceLocation("jitl", "essence"), (ICapabilityProvider)new PlayerEssenceProvider());
            }
            if (!player.getCapability(PlayerStatsProvider.PLAYER_STATS).isPresent()) {
                event.addCapability(new ResourceLocation("jitl", "player_stats"), (ICapabilityProvider)new PlayerStatsProvider());
            }
            if (!player.getCapability(PressedKeyCapProvider.PRESSED_KEY_CAP).isPresent()) {
                event.addCapability(new ResourceLocation("jitl", "pressed_keys"), (ICapabilityProvider)new PressedKeyCapProvider());
            }
            if (!player.getCapability(PlayerArmorProvider.PLAYER_ARMOR).isPresent()) {
                event.addCapability(new ResourceLocation("jitl", "player_armor"), (ICapabilityProvider)new PlayerArmorProvider());
            }
            if (!player.getCapability(PlayerPortalProvider.PORTAL).isPresent()) {
                event.addCapability(new ResourceLocation("jitl", "player_portal"), (ICapabilityProvider)new PlayerPortalProvider());
            }
        }
    }

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerEssence.class);
        event.register(PlayerStats.class);
        event.register(PressedKeyCap.class);
        event.register(PlayerArmor.class);
        event.register(PlayerPortal.class);
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(newStore -> newStore.copyFrom((PlayerEssence)oldStore)));
            event.getOriginal().getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(newStore -> newStore.copyFrom((PlayerStats)oldStore)));
            event.getOriginal().getCapability(PressedKeyCapProvider.PRESSED_KEY_CAP).ifPresent(oldStore -> event.getOriginal().getCapability(PressedKeyCapProvider.PRESSED_KEY_CAP).ifPresent(newStore -> newStore.copyFrom((PressedKeyCap)oldStore)));
            event.getOriginal().getCapability(PlayerArmorProvider.PLAYER_ARMOR).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerArmorProvider.PLAYER_ARMOR).ifPresent(newStore -> newStore.copyFrom((PlayerArmor)oldStore)));
            event.getOriginal().getCapability(PlayerPortalProvider.PORTAL).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerPortalProvider.PORTAL).ifPresent(newStore -> newStore.copyFrom((PlayerPortal)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player != null && event.phase == TickEvent.Phase.END) {
            event.player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> stats.update(event.player));
            event.player.getCapability(PlayerPortalProvider.PORTAL).ifPresent(PlayerPortal::serverTick);
            event.player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(essence -> {
                if (essence.isRegenReady()) {
                    essence.addEssence(event.player, (float)Objects.requireNonNull(event.player.m_21051_((Attribute)JAttributes.ESSENCE_REGEN_SPEED.get())).m_22135_());
                } else {
                    essence.setBurnout(essence.getBurnout() - 0.1f);
                }
                essence.sendPacket(event.player);
            });
        }
    }
}

