/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.dimension;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.jitl.common.block.portal.SenterianPortalBlock;
import net.jitl.common.block.portal.SenterianPortalFrameBlock;
import net.jitl.common.world.Surface;
import net.jitl.common.world.dimension.BaseTeleporter;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class SenterianTeleporter
extends BaseTeleporter {
    protected final ServerLevel level;
    private final SenterianPortalBlock portal_block;
    private final Block portal_frame;
    protected final ResourceKey<PoiType> poi;
    protected final ResourceKey<Level> destination;
    private static final int SEARCH_RADIUS = 256;

    public SenterianTeleporter(ServerLevel worldIn, SenterianPortalBlock portal, Block frame, ResourceKey<PoiType> poi, ResourceKey<Level> destination) {
        super(worldIn, portal, frame, poi, destination);
        this.level = worldIn;
        this.portal_block = portal;
        this.portal_frame = frame;
        this.poi = poi;
        this.destination = destination;
    }

    @Override
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo ruinedPortal;
        entity.m_20091_();
        if (destWorld.m_46472_() == Dimensions.SENTERIAN && (ruinedPortal = this.repairPortal(destWorld, destWorld.m_215011_(StructureTags.f_215892_, this.getHeight(this.level, entity.f_19819_.m_123341_(), entity.f_19819_.m_123343_()), 256, false), entity)) != null) {
            return ruinedPortal;
        }
        return this.findPlayerMadePortal(destWorld, entity, 256);
    }

    private PortalInfo repairPortal(ServerLevel level, BlockPos position, Entity entity) {
        if (position == null) {
            return null;
        }
        int surface = Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 16, 80, 0, (WorldGenLevel)level, null, position.m_123341_(), position.m_123343_());
        for (int x = position.m_123341_() - 11; x < position.m_123341_() + 11; ++x) {
            for (int y = surface - 7; y < surface + 7; ++y) {
                for (int z = position.m_123343_() - 11; z < position.m_123343_() + 11; ++z) {
                    if (!level.m_8055_(new BlockPos(x, y, z)).m_60713_((Block)this.portal_block)) continue;
                    return new PortalInfo(new Vec3((double)x, (double)y, (double)z), Vec3.f_82478_, entity.f_19859_, entity.f_19860_);
                }
            }
        }
        BlockPos pos = null;
        Block tile = (Block)JBlocks.SENTERIAN_FLOOR.get();
        block3: for (int x = position.m_123341_() - 11; x < position.m_123341_() + 11; ++x) {
            for (int y = surface - 7; y < surface + 7; ++y) {
                for (int z = position.m_123343_() - 11; z < position.m_123343_() + 11; ++z) {
                    pos = new BlockPos(x, y, z);
                    if (!level.m_8055_(pos).m_60713_(tile)) continue;
                    Block brick = (Block)JBlocks.SENTERIAN_FLOOR.get();
                    pos = level.m_8055_(pos.m_7918_(-1, 0, -1)).m_60713_(brick) ? pos.m_7918_(-5, 0, -5) : (level.m_8055_(pos.m_7918_(1, 0, -1)).m_60713_(brick) ? pos.m_7918_(-1, 0, -5) : (level.m_8055_(pos.m_7918_(-1, 0, 1)).m_60713_(brick) ? pos.m_7918_(-5, 0, -1) : (level.m_8055_(pos.m_7918_(1, 0, 1)).m_60713_(brick) ? pos.m_7918_(-1, 0, -1) : null)));
                    break block3;
                }
            }
        }
        if (pos == null) {
            return null;
        }
        return new PortalInfo(new Vec3((double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 2)), Vec3.f_82478_, entity.f_19859_, entity.f_19860_);
    }

    private PortalInfo findPlayerMadePortal(ServerLevel level, Entity entity, int searchRadius) {
        BlockPos pos = entity.m_20183_();
        PoiManager poiManager = level.m_8904_();
        poiManager.m_27056_((LevelReader)level, pos, searchRadius);
        Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType.m_203565_(this.poi), pos, searchRadius, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).findFirst();
        if (optional.isEmpty()) {
            BlockUtil.FoundRectangle r = this.makePortal(pos, null).get();
            BlockPos blockpos = r.f_124348_.m_7918_(2, 0, 2);
            level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            return new PortalInfo(new Vec3((double)(r.f_124348_.m_123341_() + 2), (double)r.f_124348_.m_123342_(), (double)(r.f_124348_.m_123343_() + 2)), Vec3.f_82478_, entity.f_19859_, entity.f_19860_);
        }
        BlockPos blockpos = optional.get().m_27257_();
        return new PortalInfo(new Vec3((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()), Vec3.f_82478_, entity.f_19859_, entity.f_19860_);
    }

    @Override
    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        int z;
        int x;
        pos = this.getHeight(this.level, pos.m_123341_(), pos.m_123343_());
        for (x = -2; x < 3; ++x) {
            for (z = -2; z < 3; ++z) {
                if (Math.abs(x) < 2 && Math.abs(z) < 2) {
                    this.level.m_7731_(pos.m_7918_(x, 0, z), this.portal_block.m_49966_(), 3);
                    continue;
                }
                if (Math.abs(z) < 2) {
                    if (x == -2) {
                        this.level.m_7731_(pos.m_7918_(x, 0, z), (BlockState)((BlockState)this.portal_frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST)).m_61124_((Property)SenterianPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true)), 3);
                        continue;
                    }
                    if (x != 2) continue;
                    this.level.m_7731_(pos.m_7918_(x, 0, z), (BlockState)((BlockState)this.portal_frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST)).m_61124_((Property)SenterianPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true)), 3);
                    continue;
                }
                if (Math.abs(x) >= 2) continue;
                if (z == -2) {
                    this.level.m_7731_(pos.m_7918_(x, 0, z), (BlockState)((BlockState)this.portal_frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)SenterianPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true)), 3);
                    continue;
                }
                this.level.m_7731_(pos.m_7918_(x, 0, z), (BlockState)((BlockState)this.portal_frame.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)SenterianPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
        for (x = -2; x < 3; ++x) {
            for (z = -2; z < 3; ++z) {
                this.level.m_7731_(pos.m_7918_(x, 1, z), Blocks.f_50016_.m_49966_(), 3);
                this.level.m_7731_(pos.m_7918_(x, 2, z), Blocks.f_50016_.m_49966_(), 3);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(pos, 5, 5));
    }

    protected BlockPos getHeight(ServerLevel level, int posX, int posZ) {
        int limit = 25;
        return new BlockPos(posX, limit, posZ);
    }
}

