/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.cloudia;

import net.jitl.core.init.JITL;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class CloudiaTerrain
extends Feature<NoneFeatureConfiguration> {
    public static CloudiaPiece[] TOP;
    public static CloudiaPiece[] BOTTOM;
    public static CloudiaPiece[] PATHS;
    public static CloudiaPiece[] TOP_PATHS;
    public static CloudiaPiece[] VILLAGE;
    public static BigRoom[] BIG_TOP;
    public static final StructurePlaceSettings defaultSettings;

    public CloudiaTerrain() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        StructureTemplateManager manager = level.m_6018_().m_7654_().m_236738_();
        PATHS = new CloudiaPiece[]{new CloudiaPiece(manager, "cloudia/crossroads/cross"), new CloudiaPiece(manager, "cloudia/crossroads/straight"), new CloudiaPiece(manager, "cloudia/crossroads/tee"), new CloudiaPiece(manager, "cloudia/crossroads/elbow")};
        TOP_PATHS = new CloudiaPiece[]{new CloudiaPiece(manager, "cloudia/crossroads/top_cross"), new CloudiaPiece(manager, "cloudia/crossroads/top_straight"), new CloudiaPiece(manager, "cloudia/crossroads/top_tee"), new CloudiaPiece(manager, "cloudia/crossroads/top_elbow")};
        TOP = new CloudiaPiece[]{new CloudiaPiece(manager, "cloudia/top/tall_house2"), new CloudiaPiece(manager, "cloudia/top/tall_house4")};
        BIG_TOP = new BigRoom[]{new BigRoom(manager, "cloudia/top/big_base")};
        BOTTOM = new CloudiaPiece[]{new CloudiaPiece(manager, "cloudia/bottom/tall_house1"), new CloudiaPiece(manager, "cloudia/bottom/island_1"), new CloudiaPiece(manager, "cloudia/bottom/tall_house3"), new CloudiaPiece(manager, "cloudia/bottom/melon_farm")};
        VILLAGE = new CloudiaPiece[]{new CloudiaPiece(manager, "cloudia/village/starlight_village"), new CloudiaPiece(manager, "cloudia/village/starlight_village_2")};
        this.generate(level, random, pos);
        return true;
    }

    public void generate(WorldGenLevel level, RandomSource random, BlockPos pos) {
        int bottomLayer = 100;
        int topLayer = bottomLayer + 12;
        int rarity = 2;
        int village_rarity = 30;
        int chunkX = pos.m_123341_() / 16;
        int chunkZ = pos.m_123343_() / 16;
        BlockPos topPos = pos.m_7918_(0, topLayer, 0);
        BlockPos bottomPos = pos.m_7918_(0, bottomLayer, 0);
        TOP_PATHS[random.m_188503_(TOP_PATHS.length)].gen(level, random, topPos, Rotation.m_221990_((RandomSource)random));
        if (random.m_188503_(rarity) == 0) {
            TOP[random.m_188503_(TOP.length)].gen(level, random, topPos, Rotation.m_221990_((RandomSource)random));
        }
        PATHS[random.m_188503_(PATHS.length)].gen(level, random, bottomPos, Rotation.m_221990_((RandomSource)random));
        if (random.m_188503_(rarity) == 0) {
            BOTTOM[random.m_188503_(BOTTOM.length)].gen(level, random, bottomPos, Rotation.m_221990_((RandomSource)random));
        }
        if (random.m_188503_(village_rarity) == 0) {
            VILLAGE[random.m_188503_(VILLAGE.length)].gen(level, random, topPos, Rotation.m_221990_((RandomSource)random));
        }
    }

    public static void placePiece(StructureTemplate structure, WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation) {
        boolean b = rotation == Rotation.CLOCKWISE_180;
        pos = pos.m_7918_(b || rotation == Rotation.CLOCKWISE_90 ? 15 : 0, 0, b || rotation == Rotation.COUNTERCLOCKWISE_90 ? 15 : 0);
        structure.m_230328_((ServerLevelAccessor)level, pos, pos, defaultSettings.m_74379_(rotation), random, 2);
    }

    static {
        defaultSettings = new StructurePlaceSettings().m_74392_(false).m_74405_(true).m_163782_(true);
    }

    private static class CloudiaPiece {
        public final StructureTemplate part;

        public CloudiaPiece(StructureTemplateManager manager, String location) {
            this.part = manager.m_230359_(JITL.rl(location));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation) {
            CloudiaTerrain.placePiece(this.part, level, random, pos, rotation);
        }
    }

    static class BigRoom {
        public final StructureTemplate room;

        public BigRoom(StructureTemplateManager manager, String room) {
            this.room = manager.m_230359_(new ResourceLocation("jitl", room));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, int xPart, int zPart) {
            if (xPart == 0) {
                if (zPart == 0) {
                    CloudiaTerrain.placePiece(this.room, level, random, pos, Rotation.NONE);
                } else {
                    CloudiaTerrain.placePiece(this.room, level, random, pos, Rotation.COUNTERCLOCKWISE_90);
                }
            } else if (zPart == 0) {
                CloudiaTerrain.placePiece(this.room, level, random, pos, Rotation.CLOCKWISE_90);
            } else {
                CloudiaTerrain.placePiece(this.room, level, random, pos, Rotation.CLOCKWISE_180);
            }
        }
    }
}

