/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.corba;

import com.mojang.serialization.Codec;
import net.jitl.common.block.JBlockFungalShelf;
import net.jitl.core.helper.RandHelper;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

public class CorbaSwampTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public CorbaSwampTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    private boolean isSpawnBlock(BlockState b) {
        return b == ((Block)JBlocks.DRIED_MUD.get()).m_49966_() || b == ((Block)JBlocks.TAINTED_MUD.get()).m_49966_();
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        int treeHeight = 5 + random.m_188503_(2) + random.m_188503_(2);
        BlockPos soilPos = blockPos.m_7495_();
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_() - 2, blockPos.m_123343_());
        if (this.isSpawnBlock(world.m_8055_(soilPos))) {
            int i;
            int stumpHeight = random.m_188503_(5) + 3;
            for (i = 0; i < stumpHeight; ++i) {
                this.placeStumps(world, basePos);
            }
            for (i = 0; i < treeHeight; ++i) {
                this.placeLog(world, basePos);
            }
            BlockPos.MutableBlockPos leafPos = basePos.m_122175_(Direction.DOWN, 2);
            for (int j5 = 0; j5 <= 10; ++j5) {
                for (int l5 = 0; l5 <= 10; ++l5) {
                    this.createCrown(world, leafPos.m_5484_(this.getRandomDirection(random), random.m_188503_(2)), random.m_188503_(3) + 1);
                    this.createCrown(world, leafPos.m_5484_(this.getRandomDirection(random), random.m_188503_(5)), random.m_188503_(3) + 1);
                    this.createCrown(world, leafPos.m_5484_(this.getRandomDirection(random), random.m_188503_(3)), random.m_188503_(3) + 1);
                    this.createCrown(world, leafPos.m_5484_(this.getRandomDirection(random), random.m_188503_(5)), random.m_188503_(3) + 1);
                }
            }
            for (int i2 = 0; i2 < random.m_188503_(5) + 2; ++i2) {
                this.placeStumps(world, basePos);
            }
            int stemChance = random.m_188503_(2);
            switch (stemChance) {
                case 0: {
                    int l5;
                    int j5;
                    for (j5 = 0; j5 <= 1; ++j5) {
                        for (l5 = 0; l5 <= 1; ++l5) {
                            this.placeStems(world, leafPos, Direction.EAST);
                        }
                    }
                }
                case 1: {
                    int l5;
                    int j5;
                    for (j5 = 0; j5 <= 1; ++j5) {
                        for (l5 = 0; l5 <= 1; ++l5) {
                            this.placeStems(world, leafPos, Direction.WEST);
                        }
                    }
                    break;
                }
            }
            for (int i3 = 0; i3 < random.m_188503_(3); ++i3) {
                this.placeMushroom(world, blockPos.m_122013_(2).m_6630_(random.m_188503_(stumpHeight - 1) + 1), Direction.NORTH);
                this.placeMushroom(world, blockPos.m_122013_(1).m_6630_(stumpHeight + 1 + random.m_188503_(treeHeight - 4)), Direction.NORTH);
                if (stemChance != 1) {
                    this.placeMushroom(world, blockPos.m_122025_(2).m_6630_(random.m_188503_(stumpHeight - 1) + 1), Direction.WEST);
                    this.placeMushroom(world, blockPos.m_122025_(1).m_6630_(stumpHeight + 1 + random.m_188503_(treeHeight - 4)), Direction.WEST);
                }
                if (stemChance != 0) {
                    this.placeMushroom(world, blockPos.m_122030_(2).m_6630_(random.m_188503_(stumpHeight - 1) + 1), Direction.EAST);
                    this.placeMushroom(world, blockPos.m_122030_(1).m_6630_(stumpHeight + 1 + random.m_188503_(treeHeight - 4)), Direction.EAST);
                }
                this.placeMushroom(world, blockPos.m_122020_(2).m_6630_(random.m_188503_(stumpHeight - 1) + 1), Direction.SOUTH);
                this.placeMushroom(world, blockPos.m_122020_(1).m_6630_(stumpHeight + 1 + random.m_188503_(treeHeight - 4)), Direction.SOUTH);
            }
        }
        return true;
    }

    private Direction getRandomDirection(RandomSource random) {
        return RandHelper.chooseEqual(random, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP);
    }

    private void placeLog(WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        this.m_5974_((LevelWriter)world, (BlockPos)pos.m_122173_(Direction.UP), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).m_49966_());
    }

    private void placeStumps(WorldGenLevel world, BlockPos.MutableBlockPos logPos) {
        this.m_5974_((LevelWriter)world, logPos.m_122173_(Direction.UP).m_122029_(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).m_49966_());
        this.m_5974_((LevelWriter)world, logPos.m_122024_(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).m_49966_());
        this.m_5974_((LevelWriter)world, logPos.m_122012_(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).m_49966_());
        this.m_5974_((LevelWriter)world, logPos.m_122019_(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).m_49966_());
    }

    private void placeStems(WorldGenLevel world, BlockPos.MutableBlockPos logPos, Direction direction) {
        this.m_5974_((LevelWriter)world, logPos.m_122175_(direction, 1).m_122175_(Direction.UP, 1).m_6625_(5), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).m_49966_());
    }

    private void createCrown(WorldGenLevel world, BlockPos pos, int size) {
        pos = pos.m_7494_();
        for (int x = 0; x <= size; x = (int)((byte)(x + 1))) {
            for (int y = 0; y <= size; y = (int)((byte)(y + 1))) {
                for (int z = 0; z <= size; z = (int)((byte)(z + 1))) {
                    int distance = x >= y & x >= z ? x + (Math.max(y, z) >> 1) + (Math.min(y, z) >> 1) : (y >= x & y >= z ? y + (Math.max(x, z) >> 1) + (Math.min(x, z) >> 1) : z + (Math.max(x, y) >> 1) + (Math.min(x, y) >> 1));
                    if (distance > size) continue;
                    this.placeLeaves(world, pos.m_7918_(-x, y, z));
                    this.placeLeaves(world, pos.m_7918_(-x, y, -z));
                    this.placeLeaves(world, pos.m_7918_(x, y, z));
                    this.placeLeaves(world, pos.m_7918_(x, y, -z));
                }
            }
        }
    }

    private void placeLeaves(WorldGenLevel world, BlockPos pos) {
        this.m_5974_((LevelWriter)world, pos, ((Block)JBlocks.BOGWOOD_LEAVES.get()).m_49966_());
    }

    private void placeMushroom(WorldGenLevel world, BlockPos pos, Direction facing) {
        this.m_5974_((LevelWriter)world, pos, (BlockState)((Block)JBlocks.FUNGAL_SHELF.get()).m_49966_().m_61124_((Property)JBlockFungalShelf.FACING, (Comparable)facing));
    }
}

