/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.depths;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.jitl.common.world.gen.depths.JDripstoneUtils;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class CrystalDripstoneClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    private final Block pointed;
    private final Block dripstone;

    public CrystalDripstoneClusterFeature(Block pointed, Block dripstone, Codec<DripstoneClusterConfiguration> c) {
        super(c);
        this.pointed = pointed;
        this.dripstone = dripstone;
    }

    public boolean m_142674_(FeaturePlaceContext<DripstoneClusterConfiguration> p_159605_) {
        WorldGenLevel worldgenlevel = p_159605_.m_159774_();
        BlockPos blockpos = p_159605_.m_159777_();
        DripstoneClusterConfiguration dripstoneclusterconfiguration = (DripstoneClusterConfiguration)p_159605_.m_159778_();
        RandomSource randomsource = p_159605_.m_225041_();
        if (!JDripstoneUtils.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        int i = dripstoneclusterconfiguration.f_160760_.m_214085_(randomsource);
        float f = dripstoneclusterconfiguration.f_160766_.m_214084_(randomsource);
        float f1 = dripstoneclusterconfiguration.f_160765_.m_214084_(randomsource);
        int j = dripstoneclusterconfiguration.f_160761_.m_214085_(randomsource);
        int k = dripstoneclusterconfiguration.f_160761_.m_214085_(randomsource);
        for (int l = -j; l <= j; ++l) {
            for (int i1 = -k; i1 <= k; ++i1) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, dripstoneclusterconfiguration);
                BlockPos blockpos1 = blockpos.m_7918_(l, 0, i1);
                this.placeColumn(worldgenlevel, randomsource, blockpos1, l, i1, f, d0, i, f1, dripstoneclusterconfiguration);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel level, RandomSource random, BlockPos pos, int x, int z, float wetness, double chance, int height, float density, DripstoneClusterConfiguration config) {
        Optional optional = Column.m_158175_((LevelSimulatedReader)level, (BlockPos)pos, (int)config.f_160759_, JDripstoneUtils::isEmptyOrWater, JDripstoneUtils::isNeitherEmptyNorWater);
        if (optional.isPresent()) {
            OptionalInt optionalint = ((Column)optional.get()).m_142011_();
            OptionalInt optionalint1 = ((Column)optional.get()).m_142009_();
            if (optionalint.isPresent() || optionalint1.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                Column column;
                boolean flag;
                boolean bl = flag = random.m_188501_() < wetness;
                if (flag && optionalint1.isPresent() && this.canPlacePool(level, pos.m_175288_(optionalint1.getAsInt()))) {
                    int i = optionalint1.getAsInt();
                    column = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    level.m_7731_(pos.m_175288_(i), Blocks.f_49990_.m_49966_(), 2);
                } else {
                    column = (Column)optional.get();
                }
                OptionalInt optionalint2 = column.m_142009_();
                boolean bl2 = flag1 = random.m_188500_() < chance;
                if (optionalint.isPresent() && flag1 && !this.isLava((LevelReader)level, pos.m_175288_(optionalint.getAsInt()))) {
                    int k = config.f_160764_.m_214085_(random);
                    this.replaceBlocksWithDripstoneBlocks(level, pos.m_175288_(optionalint.getAsInt()), k, Direction.UP);
                    int l = optionalint2.isPresent() ? Math.min(height, optionalint.getAsInt() - optionalint2.getAsInt()) : height;
                    j = this.getDripstoneHeight(random, x, z, density, l, config);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = random.m_188500_() < chance;
                if (optionalint2.isPresent() && flag2 && !this.isLava((LevelReader)level, pos.m_175288_(optionalint2.getAsInt()))) {
                    int i1 = config.f_160764_.m_214085_(random);
                    this.replaceBlocksWithDripstoneBlocks(level, pos.m_175288_(optionalint2.getAsInt()), i1, Direction.DOWN);
                    i3 = optionalint.isPresent() ? Math.max(0, j + Mth.m_216287_((RandomSource)random, (int)(-config.f_160762_), (int)config.f_160762_)) : this.getDripstoneHeight(random, x, z, density, height, config);
                } else {
                    i3 = 0;
                }
                if (optionalint.isPresent() && optionalint2.isPresent() && optionalint.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalint.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.m_216287_((RandomSource)random, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = random.m_188499_() && j3 > 0 && j1 > 0 && column.m_142030_().isPresent() && j3 + j1 == column.m_142030_().getAsInt();
                if (optionalint.isPresent()) {
                    JDripstoneUtils.growPointedDripstone(this.pointed, (LevelAccessor)level, pos.m_175288_(optionalint.getAsInt() - 1), Direction.DOWN, j3, flag3);
                }
                if (optionalint2.isPresent()) {
                    JDripstoneUtils.growPointedDripstone(this.pointed, (LevelAccessor)level, pos.m_175288_(optionalint2.getAsInt() + 1), Direction.UP, j1, flag3);
                }
            }
        }
    }

    private boolean isLava(LevelReader level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(Blocks.f_49991_);
    }

    private int getDripstoneHeight(RandomSource random, int x, int z, float chance, int height, DripstoneClusterConfiguration config) {
        if (random.m_188501_() > chance) {
            return 0;
        }
        int i = Math.abs(x) + Math.abs(z);
        float f = (float)Mth.m_144851_((double)i, (double)0.0, (double)config.f_160769_, (double)((double)height / 2.0), (double)0.0);
        return (int)CrystalDripstoneClusterFeature.randomBetweenBiased(random, height, f, config.f_160763_);
    }

    private boolean canPlacePool(WorldGenLevel level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        if (!(blockstate.m_60713_(Blocks.f_49990_) || blockstate.m_60713_((Block)JBlocks.CRYSTALLIZED_DRIPSTONE.get()) || blockstate.m_60713_((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()))) {
            if (level.m_8055_(pos.m_7494_()).m_60819_().m_205070_(FluidTags.f_13131_)) {
                return false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater((LevelAccessor)level, pos.m_121945_(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((LevelAccessor)level, pos.m_7495_());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        return blockstate.m_60713_((Block)JBlocks.DEPTHS_GRASS.get()) || blockstate.m_60713_((Block)JBlocks.DEPTHS_STONE.get()) || blockstate.m_60713_((Block)JBlocks.DEPTHS_DIRT.get()) || blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private void replaceBlocksWithDripstoneBlocks(WorldGenLevel level, BlockPos pos, int thickness, Direction direction) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 0; i < thickness; ++i) {
            if (!JDripstoneUtils.placeDripstoneBlockIfPossible(this.dripstone, (LevelAccessor)level, (BlockPos)blockpos$mutableblockpos)) {
                return;
            }
            blockpos$mutableblockpos.m_122173_(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int xRadius, int zRadius, int x, int z, DripstoneClusterConfiguration config) {
        int i = xRadius - Math.abs(x);
        int j = zRadius - Math.abs(z);
        int k = Math.min(i, j);
        return Mth.m_184631_((float)k, (float)0.0f, (float)config.f_160768_, (float)config.f_160767_, (float)1.0f);
    }

    private static float randomBetweenBiased(RandomSource random, float max, float mean, float deviation) {
        return ClampedNormalFloat.m_216837_((RandomSource)random, (float)mean, (float)deviation, (float)0.0f, (float)max);
    }
}

