/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.depths;

import java.util.function.Consumer;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class JDripstoneUtils {
    protected static double getDripstoneHeight(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double d0 = 0.384;
        double d1 = radius / maxRadius * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = scale * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * maxRadius;
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel level, BlockPos pos, int radius) {
        if (JDripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)radius;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.m_14089_((float)f2) * (float)radius);
            if (!JDripstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos.m_7918_(i, 0, j = (int)(Mth.m_14031_((float)f2) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(LevelAccessor level, BlockPos pos) {
        return level.m_7433_(pos, JDripstoneUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor level, BlockPos pos) {
        return level.m_7433_(pos, JDripstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Block pointed, Direction direction, int height, boolean mergeTip, Consumer<BlockState> blockSetter) {
        if (height >= 3) {
            blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            blockSetter.accept(JDripstoneUtils.createPointedDripstone(pointed, direction, mergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedDripstone(Block pointed, LevelAccessor level, BlockPos pos, Direction direction, int height, boolean mergeTip) {
        if (JDripstoneUtils.isDripstoneBase(level.m_8055_(pos.m_121945_(direction.m_122424_())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
            JDripstoneUtils.buildBaseToTipColumn(pointed, direction, height, mergeTip, p_313662_ -> {
                if (p_313662_.m_60713_(pointed)) {
                    p_313662_ = (BlockState)p_313662_.m_61124_((Property)PointedDripstoneBlock.f_154011_, (Comparable)Boolean.valueOf(level.m_46801_((BlockPos)blockpos$mutableblockpos)));
                }
                level.m_7731_((BlockPos)blockpos$mutableblockpos, p_313662_, 2);
                blockpos$mutableblockpos.m_122173_(direction);
            });
        }
    }

    protected static boolean placeDripstoneBlockIfPossible(Block dripstone, LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60713_((Block)JBlocks.DEPTHS_GRASS.get()) || blockstate.m_60713_((Block)JBlocks.DEPTHS_STONE.get()) || blockstate.m_60713_((Block)JBlocks.DEPTHS_DIRT.get())) {
            level.m_7731_(pos, dripstone.m_49966_(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createPointedDripstone(Block pointed, Direction direction, DripstoneThickness dripstoneThickness) {
        return (BlockState)((BlockState)pointed.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)direction)).m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)dripstoneThickness);
    }

    public static boolean isDripstoneBaseOrLava(BlockState state) {
        return JDripstoneUtils.isDripstoneBase(state) || state.m_60713_(Blocks.f_49991_);
    }

    public static boolean isDripstoneBase(BlockState state) {
        return state.m_60713_((Block)JBlocks.CRYSTALLIZED_DRIPSTONE.get()) || state.m_60713_((Block)JBlocks.DEPTHS_DRIPSTONE.get()) || state.m_60713_((Block)JBlocks.DEPTHS_GRASS.get()) || state.m_60713_((Block)JBlocks.DEPTHS_STONE.get()) || state.m_60713_((Block)JBlocks.DEPTHS_DIRT.get());
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_);
    }

    public static boolean isNeitherEmptyNorWater(BlockState state) {
        return !state.m_60795_() && !state.m_60713_(Blocks.f_49990_);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_);
    }
}

