/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.senterian;

import java.util.Random;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;

public class SenterianTerrain
extends Feature<NoneFeatureConfiguration> {
    public static final StructurePlaceSettings defaultSettings = new StructurePlaceSettings().m_74392_(false).m_74405_(true).m_163782_(true);
    public static NormalNoise senterianNoise;
    public static long seed;
    public static Room[] rooms;
    public static Room[] rareRooms;
    public static VerticalRoom[] verticalRooms;
    public static BigRoom[] bigRooms;

    public SenterianTerrain() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(null, context.m_159774_(), null, context.m_225041_(), context.m_159777_());
    }

    public boolean place(@NotNull NoneFeatureConfiguration c, WorldGenLevel level, @NotNull ChunkGenerator g, @NotNull RandomSource random, @NotNull BlockPos pos) {
        StructureTemplateManager manager = level.m_6018_().m_7654_().m_236738_();
        rooms = new Room[]{new Room(manager, "senterian/room/room_1"), new Room(manager, "senterian/room/maze_1"), new Room(manager, "senterian/hallways/cross_1"), new Room(manager, "senterian/hallways/cross_2"), new Room(manager, "senterian/hallways/hallway_straight"), new Room(manager, "senterian/hallways/corner_1")};
        rareRooms = new Room[]{new Room(manager, "senterian/room/loot_1"), new Room(manager, "senterian/room/loot_2")};
        verticalRooms = new VerticalRoom[]{new VerticalRoom(manager, "senterian/tall/staircase_hallway"), new VerticalRoom(manager, "senterian/tall/staircase_1"), new VerticalRoom(manager, "senterian/tall/tall_loot_1")};
        bigRooms = new BigRoom[]{new BigRoom(manager, "senterian/big/altar_1")};
        long newSeed = level.m_7328_();
        if (seed != newSeed) {
            senterianNoise = NormalNoise.m_230504_((RandomSource)new XoroshiroRandomSource(newSeed), (int)1, (double[])new double[]{1.5});
            seed = newSeed;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                SenterianTerrain.setBlock(level, pos.m_7918_(x, 32, z), ((Block)JBlocks.SENTERIAN_ROCK.get()).m_49966_());
            }
        }
        this.generate(level, random, pos.m_7918_(0, 24, 0), true);
        this.generate(level, random, pos.m_7918_(0, 16, 0), false);
        this.generate(level, random, pos.m_7918_(0, 8, 0), false);
        this.generate(level, random, pos.m_7918_(0, 0, 0), false);
        return true;
    }

    public void generate(WorldGenLevel level, RandomSource random, BlockPos pos, boolean topLayer) {
        int chunkX = pos.m_123341_() / 16;
        int chunkZ = pos.m_123343_() / 16;
        this.genRegular(level, random, pos);
        if (!topLayer) {
            if (random.m_188503_(10) == 0) {
                this.genRare(level, random, pos);
            }
            if (random.m_188503_(10) == 0) {
                this.genVertical(level, random, pos);
            }
            if (SenterianTerrain.wantsBigRoom(chunkX, pos.m_123342_(), chunkZ)) {
                bigRooms[random.m_188503_(bigRooms.length)].gen(level, random, pos, chunkX % 2, chunkZ % 2);
            }
        }
    }

    private void genVertical(WorldGenLevel level, RandomSource random, BlockPos pos) {
        verticalRooms[random.m_188503_(verticalRooms.length)].gen(level, random, pos, Rotation.m_221990_((RandomSource)random));
    }

    private void genRegular(WorldGenLevel level, RandomSource random, BlockPos pos) {
        rooms[random.m_188503_(rooms.length)].gen(level, random, pos, Rotation.m_221990_((RandomSource)random));
    }

    private void genRare(WorldGenLevel level, RandomSource random, BlockPos pos) {
        rareRooms[random.m_188503_(rareRooms.length)].gen(level, random, pos, Rotation.m_221990_((RandomSource)random));
    }

    public static boolean wantsBigRoom(int chunkX, int y, int chunkZ) {
        int xPart = chunkX % 2;
        int zPart = chunkZ % 2;
        Random rand = new Random();
        return rand.nextInt(15) == 0 && SenterianTerrain.getDoorAmount(chunkX, y, chunkZ) == 0 || SenterianTerrain.getDoorAmount(chunkX + 1 + (chunkX > -1 ? -2 : 2) * xPart, y, chunkZ) == 0 || SenterianTerrain.getDoorAmount(chunkX, y, chunkZ + 1 + (chunkZ > -1 ? -2 : 2) * zPart) == 0 || SenterianTerrain.getDoorAmount(chunkX + 1 + (chunkX > -1 ? -2 : 2) * xPart, y, chunkZ + 1 + (chunkZ > -1 ? -2 : 2) * zPart) == 0;
    }

    public static byte getDoorAmount(int chunkX, int y, int chunkZ) {
        byte doorValue = SenterianTerrain.getDoorValue(chunkX, y, chunkZ);
        byte hasXDoor = (byte)(doorValue % 2);
        byte hasZDoor = (byte)(doorValue / 2 % 2);
        byte hasXEntrance = (byte)(SenterianTerrain.getDoorValue(chunkX - 1, y, chunkZ) % 2);
        byte hasZEntrance = (byte)(SenterianTerrain.getDoorValue(chunkX, y, chunkZ - 1) / 2 % 2);
        return (byte)(hasXDoor + hasZDoor + hasXEntrance + hasZEntrance);
    }

    public static byte getDoorValue(int chunkX, int y, int chunkZ) {
        byte value = 0;
        for (int steps = 0; value == 0 && steps < 16; steps = (int)((byte)(steps + 1))) {
            value = (byte)(Math.abs(senterianNoise.m_75380_((double)(chunkX - 111 * steps), (double)(y + 112 * steps), (double)(chunkZ - 113 * steps))) * 15.7);
        }
        return value;
    }

    public static void placeRoom(StructureTemplate room, WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation) {
        boolean b = rotation == Rotation.CLOCKWISE_180;
        pos = pos.m_7918_(b || rotation == Rotation.CLOCKWISE_90 ? 15 : 0, 0, b || rotation == Rotation.COUNTERCLOCKWISE_90 ? 15 : 0);
        room.m_230328_((ServerLevelAccessor)level, pos, pos, defaultSettings.m_74379_(rotation), random, 2);
    }

    public static void setBlock(WorldGenLevel level, BlockPos pos, BlockState block) {
        level.m_7731_(pos, block, 3);
    }

    static class Room {
        public final StructureTemplate room;

        public Room(StructureTemplateManager manager, String location) {
            this.room = manager.m_230359_(new ResourceLocation("jitl", location));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation) {
            SenterianTerrain.placeRoom(this.room, level, random, pos, rotation);
        }
    }

    static class VerticalRoom {
        public final StructureTemplate room;

        public VerticalRoom(StructureTemplateManager manager, String location) {
            this.room = manager.m_230359_(new ResourceLocation("jitl", location));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation) {
            SenterianTerrain.placeRoom(this.room, level, random, pos, rotation);
        }
    }

    static class BigRoom {
        public final StructureTemplate room;

        public BigRoom(StructureTemplateManager manager, String room) {
            this.room = manager.m_230359_(new ResourceLocation("jitl", room));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, int xPart, int zPart) {
            if (xPart == 0) {
                if (zPart == 0) {
                    SenterianTerrain.placeRoom(this.room, level, random, pos, Rotation.NONE);
                } else {
                    SenterianTerrain.placeRoom(this.room, level, random, pos, Rotation.COUNTERCLOCKWISE_90);
                }
            } else if (zPart == 0) {
                SenterianTerrain.placeRoom(this.room, level, random, pos, Rotation.CLOCKWISE_90);
            } else {
                SenterianTerrain.placeRoom(this.room, level, random, pos, Rotation.CLOCKWISE_180);
            }
        }
    }
}

