/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.tree_grower;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.jitl.common.world.gen.tree_grower.TreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.jetbrains.annotations.NotNull;

public class JourneyTree
extends Feature<TreeConfig> {
    public JourneyTree() {
        super(TreeConfig.CODEC);
    }

    public boolean hasSpace(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return this.hasSpace(state);
    }

    public boolean hasSpace(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_);
    }

    public boolean canBeHere(WorldGenLevel level, BlockPos pos) {
        if (this.hasSpace(level, pos)) {
            BlockState state = level.m_8055_(pos.m_7495_());
            return this.defaultGrowOn(state) && level.m_8055_(pos).m_60795_() && level.m_8055_(pos) != Blocks.f_49991_.m_49966_() && state != Blocks.f_49991_.m_49966_();
        }
        return false;
    }

    private static boolean isVine(LevelSimulatedReader l, BlockPos p) {
        return l.m_7433_(p, s -> s.m_60713_(Blocks.f_50191_));
    }

    private static void setBlockKnownShape(LevelWriter l, BlockPos p, BlockState s) {
        l.m_7731_(p, s, 19);
    }

    protected boolean defaultGrowOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_);
    }

    protected void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, boolean replace) {
        BlockState block = level.m_8055_(pos);
        if (this.hasSpace(block) || replace && !block.m_60713_(Blocks.f_50752_)) {
            this.m_5974_((LevelWriter)level, pos, state);
        }
    }

    private boolean doPlace(WorldGenLevel level, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> root, BiConsumer<BlockPos, BlockState> trunk, FoliagePlacer.FoliageSetter foiliage, TreeConfig config) {
        if (this.canBeHere(level, pos)) {
            int i = config.trunkPlacer.m_226153_(random);
            int j = config.foliagePlacer.m_214116_(random, i, (TreeConfiguration)config);
            int k = i - j;
            int l = config.foliagePlacer.m_214117_(random, k);
            BlockPos blockpos = config.rootPlacer.map(p_225286_ -> p_225286_.m_225891_(pos, random)).orElse(pos);
            int i1 = Math.min(pos.m_123342_(), blockpos.m_123342_());
            int j1 = Math.max(pos.m_123342_(), blockpos.m_123342_()) + i + 1;
            if (i1 >= level.m_141937_() + 1 && j1 <= level.m_151558_()) {
                OptionalInt optionalint = config.minimumSize.m_68295_();
                int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, i, blockpos, config);
                if (k1 >= i || optionalint.isPresent() && k1 >= optionalint.getAsInt()) {
                    if (config.rootPlacer.isPresent() && !config.rootPlacer.get().m_213684_((LevelSimulatedReader)level, root, random, pos, blockpos, (TreeConfiguration)config)) {
                        return false;
                    }
                    List list = config.trunkPlacer.m_213934_((LevelSimulatedReader)level, trunk, random, k1, blockpos, (TreeConfiguration)config);
                    list.forEach(p_225279_ -> config.foliagePlacer.m_271927_((LevelSimulatedReader)level, foiliage, random, (TreeConfiguration)config, k1, p_225279_, j, l));
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader p_67216_, int p_67217_, BlockPos p_67218_, TreeConfiguration p_67219_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= p_67217_ + 1; ++i) {
            int j = p_67219_.f_68191_.m_6133_(p_67217_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)p_67218_, k, i, l);
                    if (p_67219_.f_68190_.m_226184_(p_67216_, (BlockPos)blockpos$mutableblockpos) && (p_67219_.f_68193_ || !JourneyTree.isVine(p_67216_, (BlockPos)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return p_67217_;
    }

    protected void m_5974_(@NotNull LevelWriter l, @NotNull BlockPos p, @NotNull BlockState s) {
        JourneyTree.setBlockKnownShape(l, p, s);
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfig> config) {
        final WorldGenLevel worldgenlevel = config.m_159774_();
        RandomSource randomsource = config.m_225041_();
        BlockPos blockpos = config.m_159777_();
        TreeConfig treeconfiguration = (TreeConfig)config.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p, s) -> {
            set.add(p.m_7949_());
            worldgenlevel.m_7731_(p, s, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p, s) -> {
            set1.add(p.m_7949_());
            worldgenlevel.m_7731_(p, s, 19);
        };
        FoliagePlacer.FoliageSetter biconsumer2 = new FoliagePlacer.FoliageSetter(){

            public void m_271838_(BlockPos p_272825_, @NotNull BlockState s) {
                set2.add(p_272825_.m_7949_());
                worldgenlevel.m_7731_(p_272825_, s, 19);
            }

            public boolean m_271808_(BlockPos p) {
                return set2.contains(p);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (p, s) -> {
            set3.add(p.m_7949_());
            worldgenlevel.m_7731_(p, s, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, biconsumer2, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.decorators.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.decorators.forEach(l -> l.m_214187_(treedecorator$context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(s -> {
                DiscreteVoxelShape discretevoxelshape = JourneyTree.updateLeaves((LevelAccessor)worldgenlevel, s, set1, set3, set);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)s.m_162395_(), (int)s.m_162396_(), (int)s.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor level, BoundingBox bb, Set<BlockPos> s1, Set<BlockPos> s2, Set<BlockPos> s3) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(bb.m_71056_(), bb.m_71057_(), bb.m_71058_());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList((Iterable)Sets.union(s2, s3))) {
            if (!bb.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - bb.m_162395_(), blockpos.m_123342_() - bb.m_162396_(), blockpos.m_123343_() - bb.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(s1)) {
            if (bb.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - bb.m_162395_(), blockpos1.m_123342_() - bb.m_162396_(), blockpos1.m_123343_() - bb.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (s1.contains(blockpos$mutableblockpos) || !(blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                JourneyTree.setBlockKnownShape((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!bb.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - bb.m_162395_(), blockpos$mutableblockpos.m_123342_() - bb.m_162396_(), blockpos$mutableblockpos.m_123343_() - bb.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (bb.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - bb.m_162395_(), blockpos2.m_123342_() - bb.m_162396_(), blockpos2.m_123343_() - bb.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = level.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    JourneyTree.setBlockKnownShape((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (bb.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - bb.m_162395_(), blockpos$mutableblockpos.m_123342_() - bb.m_162396_(), blockpos$mutableblockpos.m_123343_() - bb.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

