/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JItems;

public class JItemGenerator {
    protected BufferedWriter itemModelWriter;

    public void generate() {
        File itemModel;
        String itemModelDir;
        for (String name : JItems.itemName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getNormalItem("jitl", name, JItems.ItemType.ITEM);
            this.itemModelInit();
        }
        for (String name : JItems.toolName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getToolItem("jitl", name);
            this.itemModelInit();
        }
        for (String name : JItems.recordName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getNormalItem("jitl", name, JItems.ItemType.RECORD);
            this.itemModelInit();
        }
        for (String name : JItems.spawnName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getSpawnEggItem();
            this.itemModelInit();
        }
        for (String name : JItems.gunName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getGunItem("jitl", name);
            this.itemModelInit();
        }
        for (String name : JItems.hammerName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getHammerItem("jitl", name);
            this.itemModelInit();
        }
    }

    public void itemModelInit() {
        try {
            this.itemModelWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getGunItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"jitl:item/gun\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getHammerItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"jitl:item/hammer_base\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"1\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getToolItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/handheld\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getNormalItem(String modID, String name, JItems.ItemType type) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        String texName = type != JItems.ItemType.RECORD ? name : "record";
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/" + texName + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getSpawnEggItem() {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/template_spawn_egg\"");
        this.writeToItemModelFile("}");
    }
}

