/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;

public class JBlockButtonGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockPressedModelWriter;
    protected BufferedWriter blockInventoryModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.buttonBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockPressedModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_pressed.json";
            String blockInventoryModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_inventory.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockPressedModel = new File(blockPressedModelDir);
            File blockInventoryModel = new File(blockInventoryModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockPressedModel.exists()) {
                    blockPressedModel.delete();
                }
                blockPressedModel.createNewFile();
                this.blockPressedModelWriter = new BufferedWriter(new FileWriter(blockPressedModel));
                if (blockInventoryModel.exists()) {
                    blockInventoryModel.delete();
                }
                blockInventoryModel.createNewFile();
                this.blockInventoryModelWriter = new BufferedWriter(new FileWriter(blockInventoryModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "_inventory\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/button\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "{");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "  \"parent\": \"minecraft:block/button_pressed\",");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "  }");
        this.writeToBlockModelFile(this.blockPressedModelWriter, "}");
        this.writeToBlockModelFile(this.blockInventoryModelWriter, "{");
        this.writeToBlockModelFile(this.blockInventoryModelWriter, "  \"parent\": \"minecraft:block/button_inventory\",");
        this.writeToBlockModelFile(this.blockInventoryModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockInventoryModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockInventoryModelWriter, "  }");
        this.writeToBlockModelFile(this.blockInventoryModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"face=ceiling,facing=east,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=east,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=north,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=north,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=south,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=south,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"x\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=west,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=ceiling,facing=west,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=east,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=east,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=north,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=north,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=south,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=south,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=west,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=floor,facing=west,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=east,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=east,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=north,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=north,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=south,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=south,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=west,powered=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"face=wall,facing=west,powered=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_pressed\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockPressedModelWriter.close();
            this.blockInventoryModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

