/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class JBlockDripstoneGenerator {
    protected BufferedWriter blockDownBase;
    protected BufferedWriter blockDownFrustum;
    protected BufferedWriter blockDownMiddle;
    protected BufferedWriter blockDownTip;
    protected BufferedWriter blockDownTipMerge;
    protected BufferedWriter blockUpBase;
    protected BufferedWriter blockUpFrustum;
    protected BufferedWriter blockUpMiddle;
    protected BufferedWriter blockUpTip;
    protected BufferedWriter blockUpTipMerge;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.dripstoneBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockDownBaseModel = new File(blockModelDir + "down_base.json");
            File blockDownFrustumModel = new File(blockModelDir + "down_frustum.json");
            File blockDownMiddleModel = new File(blockModelDir + "down_middle.json");
            File blockDownTipModel = new File(blockModelDir + "down_tip.json");
            File blockDownTipMergeModel = new File(blockModelDir + "down_tip_merge.json");
            File blockUpBaseModel = new File(blockModelDir + "up_base.json");
            File blockUpFrustumModel = new File(blockModelDir + "up_frustum.json");
            File blockUpMiddleModel = new File(blockModelDir + "up_middle.json");
            File blockUpTipModel = new File(blockModelDir + "up_tip.json");
            File blockUpTipMergeModel = new File(blockModelDir + "up_tip_merge.json");
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockDownBaseModel.exists()) {
                    blockDownBaseModel.delete();
                }
                blockDownBaseModel.createNewFile();
                this.blockDownBase = new BufferedWriter(new FileWriter(blockDownBaseModel));
                if (blockDownFrustumModel.exists()) {
                    blockDownFrustumModel.delete();
                }
                blockDownFrustumModel.createNewFile();
                this.blockDownFrustum = new BufferedWriter(new FileWriter(blockDownFrustumModel));
                if (blockDownMiddleModel.exists()) {
                    blockDownMiddleModel.delete();
                }
                blockDownMiddleModel.createNewFile();
                this.blockDownMiddle = new BufferedWriter(new FileWriter(blockDownMiddleModel));
                if (blockDownTipModel.exists()) {
                    blockDownTipModel.delete();
                }
                blockDownTipModel.createNewFile();
                this.blockDownTip = new BufferedWriter(new FileWriter(blockDownTipModel));
                if (blockDownTipMergeModel.exists()) {
                    blockDownTipMergeModel.delete();
                }
                blockDownTipMergeModel.createNewFile();
                this.blockDownTipMerge = new BufferedWriter(new FileWriter(blockDownTipMergeModel));
                if (blockUpBaseModel.exists()) {
                    blockUpBaseModel.delete();
                }
                blockUpBaseModel.createNewFile();
                this.blockUpBase = new BufferedWriter(new FileWriter(blockUpBaseModel));
                if (blockUpFrustumModel.exists()) {
                    blockUpFrustumModel.delete();
                }
                blockUpFrustumModel.createNewFile();
                this.blockUpFrustum = new BufferedWriter(new FileWriter(blockUpFrustumModel));
                if (blockUpMiddleModel.exists()) {
                    blockUpMiddleModel.delete();
                }
                blockUpMiddleModel.createNewFile();
                this.blockUpMiddle = new BufferedWriter(new FileWriter(blockUpMiddleModel));
                if (blockUpTipModel.exists()) {
                    blockUpTipModel.delete();
                }
                blockUpTipModel.createNewFile();
                this.blockUpTip = new BufferedWriter(new FileWriter(blockUpTipModel));
                if (blockUpTipMergeModel.exists()) {
                    blockUpTipMergeModel.delete();
                }
                blockUpTipMergeModel.createNewFile();
                this.blockUpTipMerge = new BufferedWriter(new FileWriter(blockUpTipMergeModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  },");
        this.writeToItemModelFile("  \"display\": {");
        this.writeToItemModelFile("    \"thirdperson_righthand\": {");
        this.writeToItemModelFile("      \"rotation\": [ 0, 100, 0 ],");
        this.writeToItemModelFile("      \"translation\": [ -1, -1, 0],");
        this.writeToItemModelFile("      \"scale\": [ 0.9, 0.9, 0.9 ]");
        this.writeToItemModelFile("    },");
        this.writeToItemModelFile("    \"firstperson_righthand\": {");
        this.writeToItemModelFile("      \"rotation\": [ 0, 100, 0 ],");
        this.writeToItemModelFile("      \"translation\": [ 0, -2, 0],");
        this.writeToItemModelFile("      \"scale\": [ 0.9, 0.9, 0.9 ]");
        this.writeToItemModelFile("    }");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockDownBase, "{");
        this.writeToBlockModelFile(this.blockDownBase, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockDownBase, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockDownBase, "    \"cross\": \"" + modID + ":block/" + name + "_down_base\"");
        this.writeToBlockModelFile(this.blockDownBase, "  }");
        this.writeToBlockModelFile(this.blockDownBase, "}");
        this.writeToBlockModelFile(this.blockDownFrustum, "{");
        this.writeToBlockModelFile(this.blockDownFrustum, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockDownFrustum, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockDownFrustum, "    \"cross\": \"" + modID + ":block/" + name + "_down_frustum\"");
        this.writeToBlockModelFile(this.blockDownFrustum, "  }");
        this.writeToBlockModelFile(this.blockDownFrustum, "}");
        this.writeToBlockModelFile(this.blockDownMiddle, "{");
        this.writeToBlockModelFile(this.blockDownMiddle, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockDownMiddle, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockDownMiddle, "    \"cross\": \"" + modID + ":block/" + name + "_down_middle\"");
        this.writeToBlockModelFile(this.blockDownMiddle, "  }");
        this.writeToBlockModelFile(this.blockDownMiddle, "}");
        this.writeToBlockModelFile(this.blockDownTip, "{");
        this.writeToBlockModelFile(this.blockDownTip, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockDownTip, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockDownTip, "    \"cross\": \"" + modID + ":block/" + name + "_down_tip\"");
        this.writeToBlockModelFile(this.blockDownTip, "  }");
        this.writeToBlockModelFile(this.blockDownTip, "}");
        this.writeToBlockModelFile(this.blockDownTipMerge, "{");
        this.writeToBlockModelFile(this.blockDownTipMerge, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockDownTipMerge, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockDownTipMerge, "    \"cross\": \"" + modID + ":block/" + name + "_down_tip_merge\"");
        this.writeToBlockModelFile(this.blockDownTipMerge, "  }");
        this.writeToBlockModelFile(this.blockDownTipMerge, "}");
        this.writeToBlockModelFile(this.blockUpBase, "{");
        this.writeToBlockModelFile(this.blockUpBase, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockUpBase, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockUpBase, "    \"cross\": \"" + modID + ":block/" + name + "_up_base\"");
        this.writeToBlockModelFile(this.blockUpBase, "  }");
        this.writeToBlockModelFile(this.blockUpBase, "}");
        this.writeToBlockModelFile(this.blockUpFrustum, "{");
        this.writeToBlockModelFile(this.blockUpFrustum, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockUpFrustum, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockUpFrustum, "    \"cross\": \"" + modID + ":block/" + name + "_up_frustum\"");
        this.writeToBlockModelFile(this.blockUpFrustum, "  }");
        this.writeToBlockModelFile(this.blockUpFrustum, "}");
        this.writeToBlockModelFile(this.blockUpMiddle, "{");
        this.writeToBlockModelFile(this.blockUpMiddle, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockUpMiddle, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockUpMiddle, "    \"cross\": \"" + modID + ":block/" + name + "_up_middle\"");
        this.writeToBlockModelFile(this.blockUpMiddle, "  }");
        this.writeToBlockModelFile(this.blockUpMiddle, "}");
        this.writeToBlockModelFile(this.blockUpTip, "{");
        this.writeToBlockModelFile(this.blockUpTip, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockUpTip, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockUpTip, "    \"cross\": \"" + modID + ":block/" + name + "_up_tip\"");
        this.writeToBlockModelFile(this.blockUpTip, "  }");
        this.writeToBlockModelFile(this.blockUpTip, "}");
        this.writeToBlockModelFile(this.blockUpTipMerge, "{");
        this.writeToBlockModelFile(this.blockUpTipMerge, "  \"parent\": \"minecraft:block/pointed_dripstone\",");
        this.writeToBlockModelFile(this.blockUpTipMerge, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockUpTipMerge, "    \"cross\": \"" + modID + ":block/" + name + "_up_tip_merge\"");
        this.writeToBlockModelFile(this.blockUpTipMerge, "  }");
        this.writeToBlockModelFile(this.blockUpTipMerge, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"thickness=base,vertical_direction=down\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_down_base\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=base,vertical_direction=up\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_up_base\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=frustum,vertical_direction=down\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_down_frustum\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=frustum,vertical_direction=up\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_up_frustum\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=middle,vertical_direction=down\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_down_middle\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=middle,vertical_direction=up\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_up_middle\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=tip,vertical_direction=down\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_down_tip\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=tip,vertical_direction=up\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_up_tip\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=tip_merge,vertical_direction=down\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_down_tip_merge\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"thickness=tip_merge,vertical_direction=up\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_up_tip_merge\"");
        this.writeToBlockstateFile("    }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockstateWriter.close();
            this.blockDownBase.close();
            this.blockDownFrustum.close();
            this.blockDownMiddle.close();
            this.blockDownTip.close();
            this.blockDownTipMerge.close();
            this.blockUpBase.close();
            this.blockUpFrustum.close();
            this.blockUpMiddle.close();
            this.blockUpTip.close();
            this.blockUpTipMerge.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

