/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class JBlockModeledCropGenerator {
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate(String name, int maxStages) {
        String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
        String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
        File itemModel = new File(itemModelDir);
        File blockstateModel = new File(blockstateDir);
        try {
            if (itemModel.exists()) {
                itemModel.delete();
            }
            itemModel.createNewFile();
            this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            if (blockstateModel.exists()) {
                blockstateModel.delete();
            }
            blockstateModel.createNewFile();
            this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getBlockItem("jitl", name, maxStages);
        this.getBlockstate("jitl", name, maxStages);
        this.writerInit();
    }

    public void getBlockItem(String modID, String name, int maxStages) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":block/" + name + "_" + (maxStages - 1) + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockstate(String modID, String name, int maxStages) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        int j = 0;
        for (int i = 0; i < maxStages; ++i) {
            String end = ++j == maxStages ? "}" : "},";
            this.writeToBlockstateFile("   \"age=" + i + "\": {");
            this.writeToBlockstateFile("       \"model\": \"" + modID + ":block/" + name + "_" + i + "\"");
            this.writeToBlockstateFile("    " + end);
        }
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

