/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class JBlockPaneGenerator {
    protected BufferedWriter blockPostModelWriter;
    protected BufferedWriter blockPostEndsWriter;
    protected BufferedWriter blockCapModelWriter;
    protected BufferedWriter blockSideModelWriter;
    protected BufferedWriter blockCapAltModelWriter;
    protected BufferedWriter blockSideAltModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.paneBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            String blockPostModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_post.json";
            String blockPostEndsModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_post_ends.json";
            String blockPostCapModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_cap.json";
            String blockSideModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_side.json";
            String blockPostAltCapModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_cap_alt.json";
            String blockSideAltModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_side_alt.json";
            File itemModel = new File(itemModelDir);
            File blockPostModel = new File(blockPostModelDir);
            File blockPostEndsModel = new File(blockPostEndsModelDir);
            File blockPostCapModel = new File(blockPostCapModelDir);
            File blockSideModel = new File(blockSideModelDir);
            File blockPostAltCapModel = new File(blockPostAltCapModelDir);
            File blockSideAltModel = new File(blockSideAltModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockPostModel.exists()) {
                    blockPostModel.delete();
                }
                blockPostModel.createNewFile();
                this.blockPostModelWriter = new BufferedWriter(new FileWriter(blockPostModel));
                if (blockPostEndsModel.exists()) {
                    blockPostEndsModel.delete();
                }
                blockPostEndsModel.createNewFile();
                this.blockPostEndsWriter = new BufferedWriter(new FileWriter(blockPostEndsModel));
                if (blockPostCapModel.exists()) {
                    blockPostCapModel.delete();
                }
                blockPostCapModel.createNewFile();
                this.blockCapModelWriter = new BufferedWriter(new FileWriter(blockPostCapModel));
                if (blockSideModel.exists()) {
                    blockSideModel.delete();
                }
                blockSideModel.createNewFile();
                this.blockSideModelWriter = new BufferedWriter(new FileWriter(blockSideModel));
                if (blockPostAltCapModel.exists()) {
                    blockPostAltCapModel.delete();
                }
                blockPostAltCapModel.createNewFile();
                this.blockCapAltModelWriter = new BufferedWriter(new FileWriter(blockPostAltCapModel));
                if (blockSideAltModel.exists()) {
                    blockSideAltModel.delete();
                }
                blockSideAltModel.createNewFile();
                this.blockSideAltModelWriter = new BufferedWriter(new FileWriter(blockSideAltModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockPostModelWriter, "{");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  \"parent\": \"minecraft:block/iron_bars_post\",");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  \"ambientocclusion\": false,");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockPostModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockPostModelWriter, "    \"bars\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockPostModelWriter, "  }");
        this.writeToBlockModelFile(this.blockPostModelWriter, "}");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "{");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "  \"parent\": \"minecraft:block/iron_bars_post_ends\",");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "  \"ambientocclusion\": false,");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "    \"edge\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "  }");
        this.writeToBlockModelFile(this.blockPostEndsWriter, "}");
        this.writeToBlockModelFile(this.blockCapModelWriter, "{");
        this.writeToBlockModelFile(this.blockCapModelWriter, "  \"parent\": \"minecraft:block/iron_bars_cap\",");
        this.writeToBlockModelFile(this.blockCapModelWriter, "  \"ambientocclusion\": false,");
        this.writeToBlockModelFile(this.blockCapModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockCapModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockCapModelWriter, "    \"bars\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockCapModelWriter, "    \"edge\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockCapModelWriter, "  }");
        this.writeToBlockModelFile(this.blockCapModelWriter, "}");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "{");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "  \"parent\": \"minecraft:block/iron_bars_cap_alt\",");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "  \"ambientocclusion\": false,");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "    \"bars\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "    \"edge\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "  }");
        this.writeToBlockModelFile(this.blockCapAltModelWriter, "}");
        this.writeToBlockModelFile(this.blockSideModelWriter, "{");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  \"parent\": \"minecraft:block/iron_bars_side\",");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  \"ambientocclusion\": false,");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockSideModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockSideModelWriter, "    \"bars\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockSideModelWriter, "    \"edge\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockSideModelWriter, "  }");
        this.writeToBlockModelFile(this.blockSideModelWriter, "}");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "{");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "  \"parent\": \"minecraft:block/iron_bars_side_alt\",");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "  \"ambientocclusion\": false,");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "    \"bars\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "    \"edge\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "  }");
        this.writeToBlockModelFile(this.blockSideAltModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"multipart\": [");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_post_ends\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_post\"");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"false\",");
        this.writeToBlockstateFile("            \"north\": \"false\",");
        this.writeToBlockstateFile("            \"south\": \"false\",");
        this.writeToBlockstateFile("            \"west\": \"false\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_cap\"");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"false\",");
        this.writeToBlockstateFile("            \"north\": \"true\",");
        this.writeToBlockstateFile("            \"south\": \"false\",");
        this.writeToBlockstateFile("            \"west\": \"false\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_cap\",");
        this.writeToBlockstateFile("            \"y\": 90");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"true\",");
        this.writeToBlockstateFile("            \"north\": \"false\",");
        this.writeToBlockstateFile("            \"south\": \"false\",");
        this.writeToBlockstateFile("            \"west\": \"false\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_cap_alt\"");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"false\",");
        this.writeToBlockstateFile("            \"north\": \"false\",");
        this.writeToBlockstateFile("            \"south\": \"true\",");
        this.writeToBlockstateFile("            \"west\": \"false\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_cap_alt\",");
        this.writeToBlockstateFile("            \"y\": 90");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"false\",");
        this.writeToBlockstateFile("            \"north\": \"false\",");
        this.writeToBlockstateFile("            \"south\": \"false\",");
        this.writeToBlockstateFile("            \"west\": \"true\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side\"");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"north\": \"true\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockstateFile("            \"y\": 90");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"east\": \"true\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side_alt\"");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"south\": \"true\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("     {");
        this.writeToBlockstateFile("        \"apply\": {");
        this.writeToBlockstateFile("            \"model\": \"" + modID + ":block/" + name + "_side_alt\",");
        this.writeToBlockstateFile("            \"y\": 90");
        this.writeToBlockstateFile("        },");
        this.writeToBlockstateFile("        \"when\": {");
        this.writeToBlockstateFile("            \"west\": \"true\"");
        this.writeToBlockstateFile("        }");
        this.writeToBlockstateFile("     }");
        this.writeToBlockstateFile("  ]");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockPostModelWriter.close();
            this.blockPostEndsWriter.close();
            this.blockCapModelWriter.close();
            this.blockSideModelWriter.close();
            this.blockCapAltModelWriter.close();
            this.blockSideAltModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

