/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class JBlockPillarGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockHorModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.logBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockHorModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_horizontal.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockHorModel = new File(blockHorModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockHorModel.exists()) {
                    blockHorModel.delete();
                }
                blockHorModel.createNewFile();
                this.blockHorModelWriter = new BufferedWriter(new FileWriter(blockHorModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockHorModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("  \"parent\": \"minecraft:block/cube_column\",");
        this.writeToBlockModelFile("  \"textures\": {");
        this.writeToBlockModelFile("    \"end\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockModelFile("    \"side\": \"" + modID + ":block/" + name + "_side\"");
        this.writeToBlockModelFile("  }");
        this.writeToBlockModelFile("}");
    }

    public void getBlockHorModel(String modID, String name) {
        this.writeToBlockHorModelFile("{");
        this.writeToBlockHorModelFile("  \"parent\": \"minecraft:block/cube_column_horizontal\",");
        this.writeToBlockHorModelFile("  \"textures\": {");
        this.writeToBlockHorModelFile("    \"end\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockHorModelFile("    \"side\": \"" + modID + ":block/" + name + "_side\"");
        this.writeToBlockHorModelFile("  }");
        this.writeToBlockHorModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"axis=x\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_horizontal\",");
        this.writeToBlockstateFile("         \"x\": 90,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"axis=y\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"axis=z\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_horizontal\",");
        this.writeToBlockstateFile("         \"x\": 90");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockHorModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockHorModelFile(String text) {
        try {
            this.blockHorModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

