/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class JBlockSlimeGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.slimeBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("   \"parent\": \"block/thin_block\",");
        this.writeToBlockModelFile("    \"textures\": {");
        this.writeToBlockModelFile("        \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile("        \"texture\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile("    },");
        this.writeToBlockModelFile("    \"elements\": [");
        this.writeToBlockModelFile("        {   \"from\": [ 0, 0, 0 ],");
        this.writeToBlockModelFile("            \"to\": [ 16, 2, 16 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"down\":  { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#texture\", \"cullface\": \"down\" },");
        this.writeToBlockModelFile("                \"up\":    { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#texture\" },");
        this.writeToBlockModelFile("                \"north\": { \"uv\": [ 0, 14, 16, 16 ], \"texture\": \"#texture\", \"cullface\": \"north\" },");
        this.writeToBlockModelFile("                \"south\": { \"uv\": [ 0, 14, 16, 16 ], \"texture\": \"#texture\", \"cullface\": \"south\" },");
        this.writeToBlockModelFile("                \"west\":  { \"uv\": [ 0, 14, 16, 16 ], \"texture\": \"#texture\", \"cullface\": \"west\" },");
        this.writeToBlockModelFile("                \"east\":  { \"uv\": [ 0, 14, 16, 16 ], \"texture\": \"#texture\", \"cullface\": \"east\" }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        }");
        this.writeToBlockModelFile("    ]");
        this.writeToBlockModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("  \"\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("     }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

