/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class JBlockTrapDoorGenerator {
    protected BufferedWriter blockBottomModelWriter;
    protected BufferedWriter blockTopModelWriter;
    protected BufferedWriter blockOpenModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.trapDoorBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockBottomModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_bottom.json";
            String blockTopModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_top.json";
            String blockOpenModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_open.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockBottomModel = new File(blockBottomModelDir);
            File blockTopModel = new File(blockTopModelDir);
            File blockOpenModel = new File(blockOpenModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockBottomModel.exists()) {
                    blockBottomModel.delete();
                }
                blockBottomModel.createNewFile();
                this.blockBottomModelWriter = new BufferedWriter(new FileWriter(blockBottomModel));
                if (blockTopModel.exists()) {
                    blockTopModel.delete();
                }
                blockTopModel.createNewFile();
                this.blockTopModelWriter = new BufferedWriter(new FileWriter(blockTopModel));
                if (blockOpenModel.exists()) {
                    blockOpenModel.delete();
                }
                blockOpenModel.createNewFile();
                this.blockOpenModelWriter = new BufferedWriter(new FileWriter(blockOpenModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "_bottom\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockBottomModelWriter, "{");
        this.writeToBlockModelFile(this.blockBottomModelWriter, "  \"parent\": \"minecraft:block/template_orientable_trapdoor_bottom\",");
        this.writeToBlockModelFile(this.blockBottomModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockBottomModelWriter, "    \"texture\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockBottomModelWriter, "  }");
        this.writeToBlockModelFile(this.blockBottomModelWriter, "}");
        this.writeToBlockModelFile(this.blockTopModelWriter, "{");
        this.writeToBlockModelFile(this.blockTopModelWriter, "  \"parent\": \"minecraft:block/template_orientable_trapdoor_top\",");
        this.writeToBlockModelFile(this.blockTopModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockTopModelWriter, "    \"texture\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockTopModelWriter, "  }");
        this.writeToBlockModelFile(this.blockTopModelWriter, "}");
        this.writeToBlockModelFile(this.blockOpenModelWriter, "{");
        this.writeToBlockModelFile(this.blockOpenModelWriter, "  \"parent\": \"minecraft:block/template_orientable_trapdoor_open\",");
        this.writeToBlockModelFile(this.blockOpenModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockOpenModelWriter, "    \"texture\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockOpenModelWriter, "  }");
        this.writeToBlockModelFile(this.blockOpenModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_bottom\",");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=bottom,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,half=top,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_bottom\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=bottom,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_top\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,half=top,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_bottom\",");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=bottom,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,half=top,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 0");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_bottom\",");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=bottom,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,half=top,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"x\": 180,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockBottomModelWriter.close();
            this.blockTopModelWriter.close();
            this.blockOpenModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

