/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.jitl.core.helper.internal.ReflectionHelper;

public interface EnumLookup<E extends Enum<E>, S> {
    public E by(S var1);

    public S from(E var1);

    public static <T extends Enum<T>, S> EnumLookup<T, S> make(Class<T> enumClass, Function<T, S> idSupplier) {
        Enum[] enumValues = ReflectionHelper.getEnumValues(enumClass);
        HashMap<S, Enum> idLookup = new HashMap<S, Enum>(enumValues.length);
        for (Enum val : enumValues) {
            if (idLookup.put(idSupplier.apply(val), val) == null) continue;
            throw new IllegalArgumentException("Found duplication of id " + idSupplier.apply(val) + " for " + enumClass.getName());
        }
        return new MapBasedLookup(enumClass, idLookup, idSupplier);
    }

    public static <T extends Enum<T>> IndexBasedLookup<T> makeFromOrdinal(Class<T> enumClass) {
        return new IndexBasedLookup<T>(enumClass);
    }

    public static class MapBasedLookup<E extends Enum<E>, S>
    implements EnumLookup<E, S> {
        private final Class<E> clazz;
        private final Map<S, E> lookup;
        private final Function<E, S> toIdFunc;

        private MapBasedLookup(Class<E> clazz, Map<S, E> lookup, Function<E, S> toIdFunc) {
            this.clazz = clazz;
            this.lookup = lookup;
            this.toIdFunc = toIdFunc;
        }

        @Override
        public E by(S id) {
            if (!this.lookup.containsKey(id)) {
                throw new IllegalArgumentException("Instance of enum " + this.clazz.getSimpleName() + " was not found for id '" + id + "'");
            }
            return (E)((Enum)this.lookup.get(id));
        }

        @Override
        public S from(E value) {
            return this.toIdFunc.apply(value);
        }
    }

    public static class IndexBasedLookup<E extends Enum<E>>
    implements EnumLookup<E, Integer> {
        private final Class<E> clazz;
        private final E[] values;

        private IndexBasedLookup(Class<E> clazz) {
            this.clazz = clazz;
            this.values = ReflectionHelper.getEnumValues(clazz);
        }

        @Override
        public E by(Integer id) {
            if (id < 0 || id >= this.values.length) {
                throw new IllegalArgumentException("There's no instance " + this.clazz.getSimpleName() + " with index '" + id + "'");
            }
            return this.values[id];
        }

        @Override
        public Integer from(E value) {
            return ((Enum)value).ordinal();
        }
    }
}

