/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper.internal;

public class MathUtils {
    public static int coerceInRange(int number, int min, int max) {
        return Math.min(Math.max(number, min), max);
    }

    public static float coerceInRange(float number, float min, float max) {
        return Math.min(Math.max(number, min), max);
    }

    public static long coerceInRange(long number, long min, long max) {
        return Math.min(Math.max(number, min), max);
    }

    public static double coerceInRange(double number, double min, double max) {
        return Math.min(Math.max(number, min), max);
    }

    public static float lerp(float factor, float start, float end) {
        return start + factor * (end - start);
    }

    public static double lerp(double factor, double start, double end) {
        return start + factor * (end - start);
    }

    public static float percentage(float current, float start, float end) {
        return end - start != 0.0f ? (current - start) / (end - start) : 1.0f;
    }

    public static double percentage(double current, double start, double end) {
        return end - start != 0.0 ? (current - start) / (end - start) : 1.0;
    }

    public static double difference(double number1, double number2) {
        return Math.abs(number1 - number2);
    }

    public static int average(int ... vals) {
        if (vals.length == 0) {
            return 0;
        }
        int s = 0;
        for (int val : vals) {
            s += val;
        }
        return s / vals.length;
    }

    public static int min(int ... vals) {
        if (vals.length == 0) {
            throw new IllegalArgumentException("Can't get minimum value from zero-sized array.");
        }
        int min = Integer.MAX_VALUE;
        for (int val : vals) {
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    public static int max(int ... vals) {
        if (vals.length == 0) {
            throw new IllegalArgumentException("Can't get maximum value from zero-sized array.");
        }
        int max = Integer.MIN_VALUE;
        for (int val : vals) {
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    public static float min(float ... vals) {
        if (vals.length == 0) {
            throw new IllegalArgumentException("Can't get minimum value from zero-sized array.");
        }
        float min = Float.MAX_VALUE;
        for (float val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static float max(float ... vals) {
        if (vals.length == 0) {
            throw new IllegalArgumentException("Can't get maximum value from zero-sized array.");
        }
        float max = Float.MIN_VALUE;
        for (float val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static double min(double ... vals) {
        if (vals.length == 0) {
            throw new IllegalArgumentException("Can't get minimum value from zero-sized array.");
        }
        double min = Double.MAX_VALUE;
        for (double val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static double max(double ... vals) {
        if (vals.length == 0) {
            throw new IllegalArgumentException("Can't get maximum value from zero-sized array.");
        }
        double max = Double.MIN_VALUE;
        for (double val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static float toRadians(float degrees) {
        return degrees / 180.0f * (float)Math.PI;
    }

    public static float toDegrees(float radians) {
        return radians * 180.0f / (float)Math.PI;
    }

    public static double toRadians(double degrees) {
        return Math.toRadians(degrees);
    }

    public static double toDegrees(double radians) {
        return Math.toDegrees(radians);
    }
}

