/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper.internal;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RandomSource;

public class RandHelper {
    public static RandomSource RAND = RandomSource.m_216327_();

    public static <T> T flipCoin(RandomSource random, T a, T b) {
        return random.m_188499_() ? a : b;
    }

    public static <T> T chance(RandomSource random, int chance, T a, T b) {
        return RandHelper.chance(random, chance) ? a : b;
    }

    public static boolean chance(RandomSource random, int chance) {
        if (chance > 100) {
            throw new IllegalArgumentException("Chance shouldn't be greater than 100. Provided: " + chance);
        }
        return random.m_188503_(100) < chance;
    }

    @SafeVarargs
    public static <T> T chooseEqually(RandomSource r, T ... items) {
        return items[r.m_188503_(items.length)];
    }

    public static <T> T chooseEqually(Random r, List<T> items) {
        return items.get(r.nextInt(items.size()));
    }

    public static <T> T chooseEqually(Random r, Collection<T> items) {
        int i = 0;
        int size = items.size();
        int selected = r.nextInt(size);
        for (T item : items) {
            if (i == selected) {
                return item;
            }
            ++i;
        }
        throw new IllegalArgumentException("Can't find randomly chosen element while iterating the collection.");
    }
}

