/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init;

import net.jitl.client.ClientEventHandler;
import net.jitl.client.gui.BossBarRenderer;
import net.jitl.client.render.ModelPropertyRegistry;
import net.jitl.client.render.RenderEntitys;
import net.jitl.common.world.ModEvents;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.common.world.dimension.JCarver;
import net.jitl.common.world.gen.JFeatures;
import net.jitl.common.world.gen.JFoliagePlacers;
import net.jitl.common.world.gen.JTreeDecorators;
import net.jitl.core.config.JClientConfig;
import net.jitl.core.config.JCommonConfig;
import net.jitl.core.data.JNetworkRegistry;
import net.jitl.core.init.compat.ModCompat;
import net.jitl.core.init.internal.JAttributes;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JContainers;
import net.jitl.core.init.internal.JEnchantments;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JParticleManager;
import net.jitl.core.init.internal.JSounds;
import net.jitl.core.init.internal.JTabs;
import net.jitl.core.init.internal.LogStripper;
import net.jitl.core.init.internal.StructureRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jitl")
public class JITL {
    public static final String MODID = "jitl";
    public static final String PREFIX = "jitl:";
    public static final String MOD_VERSION = "2.2.4";
    public static final String MOD_NAME = "Journey Into the Light";
    public static final Logger LOGGER = LogManager.getLogger((String)"jitl");
    public static final boolean DEV_MODE = false;

    public JITL() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(JTabs::registerTabs);
        JItems.ITEMS.register(modEventBus);
        JBlocks.BLOCKS.register(modEventBus);
        JItems.BLOCK_ITEMS.register(modEventBus);
        JEntities.REGISTRY.register(modEventBus);
        JAttributes.REGISTRY.register(modEventBus);
        JFoliagePlacers.REGISTRY.register(modEventBus);
        JFeatures.REGISTRY.register(modEventBus);
        JContainers.REGISTRY.register(modEventBus);
        JBlockEntities.REGISTRY.register(modEventBus);
        Dimensions.REGISTRY.register(modEventBus);
        JCarver.REGISTRY.register(modEventBus);
        StructureRegistry.REGISTRY.register(modEventBus);
        JEnchantments.REGISTRY.register(modEventBus);
        JParticleManager.REGISTRY.register(modEventBus);
        JTreeDecorators.REGISTRY.register(modEventBus);
        JSounds.REGISTRY.register(modEventBus);
        JTabs.REGISTRY.register(modEventBus);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, ModEvents::onPlayerAttachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(ModEvents::onRegisterCapabilities);
        modEventBus.addListener(this::commonInit);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::enqueue);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)JClientConfig.SPEC, "jitl-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)JCommonConfig.SPEC, "jitl-common.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonInit(FMLCommonSetupEvent event) {
        JNetworkRegistry.init();
        ModCompat.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        RenderEntitys.registerAnimationRenderers();
        ModelPropertyRegistry.init();
        JContainers.register();
        BossBarRenderer.init();
        LogStripper.init();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ClientEventHandler.regToBus(forgeEventBus);
    }

    private void enqueue(InterModEnqueueEvent event) {
    }

    public static ResourceLocation rl(String r) {
        return new ResourceLocation(MODID, r);
    }

    public static ResourceLocation tl(String r) {
        return new ResourceLocation(MODID, "textures/" + r);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entity);
    }
}

