/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.jitl.common.entity.IJourneyBoss;
import net.jitl.common.entity.base.JBossInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PacketBossBar {
    private final Operation addOrRemove;
    private final UUID barUUID;
    private final int bossNum;

    public PacketBossBar(FriendlyByteBuf buf) {
        this.addOrRemove = (Operation)buf.m_130066_(Operation.class);
        this.barUUID = buf.m_130259_();
        this.bossNum = buf.readInt();
    }

    public PacketBossBar(Operation aor, UUID uuid, Entity boss) {
        this.addOrRemove = aor;
        this.barUUID = uuid;
        this.bossNum = boss.m_19879_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.addOrRemove);
        buffer.m_130077_(this.barUUID);
        buffer.writeInt(this.bossNum);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        switch (this.addOrRemove) {
            case ADD: {
                assert (Minecraft.m_91087_().f_91073_ != null);
                Entity boss = Minecraft.m_91087_().f_91073_.m_6815_(this.bossNum);
                if (boss instanceof IJourneyBoss) {
                    JBossInfo.map.put(this.barUUID, (IJourneyBoss)boss);
                    break;
                }
                assert (boss != null);
                throw new IllegalStateException("Attempted to add boss info to " + boss.getClass().getName());
            }
            case REMOVE: {
                JBossInfo.map.remove(this.barUUID);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ctx.get().setPacketHandled(true);
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }
}

