/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.network;

import java.util.function.Supplier;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketBuyItem {
    private final String itemName;
    private final int amount;
    private final int cost;

    public PacketBuyItem(FriendlyByteBuf buf) {
        this.itemName = buf.m_130277_();
        this.amount = buf.readInt();
        this.cost = buf.readInt();
    }

    public PacketBuyItem(String itemName, int amount, int cost) {
        this.itemName = itemName;
        this.amount = amount;
        this.cost = cost;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.itemName);
        buffer.writeInt(this.amount);
        buffer.writeInt(this.cost);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        assert (player != null);
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("jitl", this.itemName));
            if (stats.useSentacoins(this.cost)) {
                assert (item != null);
                player.m_36356_(new ItemStack((ItemLike)item, this.amount));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"jitl.trade.no"));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

