/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.network;

import java.util.function.Supplier;
import net.jitl.client.util.ClientPlayerMovement;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateClientPlayerMovement {
    private final double x;
    private final double y;
    private final double z;
    private final Operation operation;

    public PacketUpdateClientPlayerMovement(Operation operation, double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.operation = operation;
    }

    public PacketUpdateClientPlayerMovement(FriendlyByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.operation = (Operation)buf.m_130066_(Operation.class);
    }

    public PacketUpdateClientPlayerMovement(Operation operation, double x, double z) {
        this(operation, x, 0.0, z);
    }

    public PacketUpdateClientPlayerMovement(Operation operation, double y) {
        this(operation, 0.0, y, 0.0);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.m_130068_((Enum)this.operation);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ClientPlayerMovement.adjustPlayerMovement(this.x, this.y, this.z, this.operation);
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum Operation {
        SET,
        ADD,
        MULTIPLY,
        MAX,
        MIN;

    }
}

