/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.api.projectile;

import com.rekindled.embers.api.projectile.IProjectileEffect;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageEmberRayFX;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3f;

public class ProjectileRay
implements IProjectilePreset {
    Vec3 pos;
    Vec3 velocity;
    IProjectileEffect effect;
    Entity shooter;
    boolean pierceEntities;
    ResourceLocation colorId = EmbersColors.EMBER_ID;
    Vector3f color = EmbersColors.EMBER;

    public ProjectileRay(Entity shooter, Vec3 start, Vec3 end, boolean pierceEntities, IProjectileEffect effect) {
        this.pos = start;
        this.velocity = end.m_82546_(start);
        this.effect = effect;
        this.shooter = shooter;
        this.pierceEntities = pierceEntities;
    }

    @Override
    public Vec3 getPos() {
        return this.pos;
    }

    @Override
    public void setPos(Vec3 pos) {
        this.pos = pos;
    }

    @Override
    public Vec3 getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Vec3 velocity) {
        this.velocity = velocity;
    }

    @Override
    public Vector3f getColor() {
        return this.color;
    }

    @Override
    public ResourceLocation getColorId() {
        return this.colorId;
    }

    @Override
    public void setColor(Vector3f color) {
        this.color = color;
        this.colorId = EmbersColors.CUSTOM_ID;
    }

    @Override
    public void setColor(ResourceLocation color) {
        this.colorId = color;
    }

    @Override
    @Deprecated
    public void setColor(Color color) {
        this.setColor(Misc.colorFromInt(color.getRGB()));
    }

    @Override
    public IProjectileEffect getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public boolean canPierceEntities() {
        return this.pierceEntities;
    }

    public void setPierceEntities(boolean pierceEntities) {
        this.pierceEntities = pierceEntities;
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return null;
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    @Override
    public void shoot(Level world) {
        double startX = this.getPos().f_82479_;
        double startY = this.getPos().f_82480_;
        double startZ = this.getPos().f_82481_;
        double dX = this.getVelocity().f_82479_;
        double dY = this.getVelocity().f_82480_;
        double dZ = this.getVelocity().f_82481_;
        double impactDist = Double.POSITIVE_INFINITY;
        boolean doContinue = true;
        Vec3 currPosVec = this.getPos();
        Vec3 newPosVector = this.getPos().m_82549_(this.getVelocity());
        BlockHitResult blockTrace = world.m_45547_(new ClipContext(currPosVec, newPosVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.shooter));
        List<EntityHitResult> entityTraces = Misc.getEntityHitResults(world, null, this.shooter, currPosVec, newPosVector, new AABB(startX - 0.3, startY - 0.3, startZ - 0.3, startX + 0.3, startY + 0.3, startZ + 0.3), EntitySelector.f_20408_, 0.3f);
        double distBlock = blockTrace != null ? this.getPos().m_82557_(blockTrace.m_82450_()) : Double.POSITIVE_INFINITY;
        for (HitResult hitResult : entityTraces) {
            if (!doContinue || hitResult == null || !(this.getPos().m_82557_(hitResult.m_82450_()) < distBlock)) continue;
            this.effect.onHit(world, hitResult, this);
            if (this.pierceEntities) continue;
            impactDist = this.getPos().m_82554_(hitResult.m_82450_());
            doContinue = false;
        }
        if (doContinue && blockTrace != null) {
            this.effect.onHit(world, (HitResult)blockTrace, this);
            impactDist = this.getPos().m_82554_(blockTrace.m_82450_());
            doContinue = false;
        }
        if (doContinue) {
            this.effect.onFizzle(world, newPosVector, this);
            impactDist = this.getPos().m_82554_(newPosVector);
        }
        if (!world.f_46443_) {
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.shooter), (Object)new MessageEmberRayFX(startX, startY, startZ, dX, dY, dZ, impactDist, Misc.intColor(this.color), this.colorId));
        }
    }
}

