/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.datagen.EmbersSounds;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WindingGearsAugment
extends AugmentBase {
    public static final ResourceLocation TEXTURE_HUD = new ResourceLocation("embers:textures/gui/icons.png");
    public static final int BAR_U = 0;
    public static final int BAR_V = 32;
    public static final int BAR_WIDTH = 180;
    public static final int BAR_HEIGHT = 8;
    public static final String TAG_CHARGE = "windingGearsCharge";
    public static final String TAG_CHARGE_TIME = "windingGearsLastTime";
    public static final double MAX_CHARGE = 500.0;
    public static final int CHARGE_DECAY_DELAY = 20;
    public static final double CHARGE_DECAY = 0.25;
    static int ticks;
    static double angle;
    static double angleLast;
    static int spool;
    static int spoolLast;
    static ThreadLocal<Map<Entity, Double>> bounceLocal;

    public WindingGearsAugment(ResourceLocation id) {
        super(id, 0.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getBarY(int height) {
        return height - 31;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getBarX(int width) {
        return width / 2 - 11 - 81;
    }

    public static ItemStack getHeldClockworkTool(LivingEntity entity) {
        boolean isClockworkOff;
        ItemStack mainStack = entity.m_21205_();
        ItemStack offStack = entity.m_21206_();
        boolean isClockworkMain = WindingGearsAugment.isClockworkTool(mainStack);
        if (isClockworkMain == (isClockworkOff = WindingGearsAugment.isClockworkTool(offStack))) {
            return ItemStack.f_41583_;
        }
        if (isClockworkMain) {
            return mainStack;
        }
        return offStack;
    }

    public static boolean isClockworkTool(ItemStack stack) {
        return AugmentUtil.hasHeat(stack) && AugmentUtil.hasAugment(stack, RegistryManager.WINDING_GEARS_AUGMENT);
    }

    public static double getChargeDecay(Level world, ItemStack stack) {
        return 0.25;
    }

    public static double getCharge(Level world, ItemStack stack) {
        if (stack.m_41782_()) {
            long dTime = WindingGearsAugment.getTimeSinceLastCharge(world, stack);
            return Math.max(0.0, stack.m_41783_().m_128459_(TAG_CHARGE) - (double)Math.max(0L, dTime - 20L) * WindingGearsAugment.getChargeDecay(world, stack));
        }
        return 0.0;
    }

    private static long getTimeSinceLastCharge(Level world, ItemStack stack) {
        if (stack.m_41782_()) {
            long currentTime;
            long lastTime = stack.m_41783_().m_128454_(TAG_CHARGE_TIME);
            if (lastTime > (currentTime = world.m_46467_())) {
                return 0L;
            }
            return currentTime - lastTime;
        }
        return Long.MAX_VALUE;
    }

    public static double getMaxCharge(Level world, ItemStack stack) {
        int level = WindingGearsAugment.getClockworkLevel(stack);
        return Math.min(200.0 * (double)level, 500.0);
    }

    private static int getClockworkLevel(ItemStack stack) {
        int level = AugmentUtil.getAugmentLevel(stack, RegistryManager.WINDING_GEARS_AUGMENT);
        return level;
    }

    public static void setCharge(Level world, ItemStack stack, double charge) {
        if (world.m_5776_()) {
            return;
        }
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            tagCompound.m_128347_(TAG_CHARGE, charge);
            tagCompound.m_128356_(TAG_CHARGE_TIME, world.m_46467_());
        }
    }

    public static void depleteCharge(Level world, ItemStack stack, double charge) {
        WindingGearsAugment.setCharge(world, stack, Math.max(0.0, WindingGearsAugment.getCharge(world, stack) - charge));
    }

    public static void addCharge(Level world, ItemStack stack, double charge) {
        if (world.m_5776_()) {
            return;
        }
        WindingGearsAugment.setCharge(world, stack, Math.min(WindingGearsAugment.getMaxCharge(world, stack), WindingGearsAugment.getCharge(world, stack) + charge));
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            tagCompound.m_128356_(TAG_CHARGE_TIME, world.m_46467_());
        }
    }

    public static float getSpeedBonus(Level world, ItemStack stack) {
        double charge = WindingGearsAugment.getCharge(world, stack);
        return (float)Mth.m_14085_((double)-0.2, (double)20.0, (double)((charge - 50.0) / 300.0));
    }

    public static float getDamageBonus(Level world, ItemStack stack) {
        double charge = WindingGearsAugment.getCharge(world, stack);
        return (float)Mth.m_14085_((double)1.0, (double)6.0, (double)((charge - 50.0) / 300.0));
    }

    public static double getRotationSpeed(Level world, ItemStack stack) {
        long dTime = WindingGearsAugment.getTimeSinceLastCharge(world, stack);
        double charge = WindingGearsAugment.getCharge(world, stack);
        double standardSpeed = Mth.m_14085_((double)0.0, (double)400.0, (double)(charge / 500.0));
        if (dTime > 20L && charge > 0.0) {
            return Mth.m_14085_((double)0.0, (double)-10.0, (double)((double)(dTime - 20L) / 10.0));
        }
        return Mth.m_14085_((double)standardSpeed, (double)0.0, (double)((double)(dTime - 10L) / 10.0));
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = WindingGearsAugment.getHeldClockworkTool(entity);
        if (!stack.m_41619_() && WindingGearsAugment.isClockworkTool(entity.m_6844_(EquipmentSlot.FEET))) {
            double charge = WindingGearsAugment.getCharge(entity.m_9236_(), stack);
            double cost = Math.max(16.0, charge * 0.16);
            if (charge > 0.0) {
                double x = 0.0;
                double z = 0.0;
                if (entity.m_20142_() && charge > Math.max(40.0, cost * 1.5)) {
                    x = entity.m_20184_().f_82479_;
                    z = entity.m_20184_().f_82481_;
                    cost = Math.max(40.0, cost * 1.5);
                }
                entity.m_20256_(entity.m_20184_().m_82549_(new Vec3(x, Mth.m_14085_((double)0.0, (double)0.35, (double)(charge / 500.0)), z)));
                if (charge >= cost) {
                    entity.m_5496_((SoundEvent)EmbersSounds.WINDING_GEARS_SPRING.get(), 1.0f, 1.0f);
                }
            }
            if (!entity.m_9236_().m_5776_()) {
                WindingGearsAugment.depleteCharge(entity.m_9236_(), stack, cost);
            }
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Map<Entity, Double> bounce = bounceLocal.get();
        if (bounce.containsKey(entity)) {
            entity.m_20256_(entity.m_20184_().m_82549_(new Vec3(0.0, bounce.get(entity).doubleValue(), 0.0)));
            bounce.remove(entity);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = WindingGearsAugment.getHeldClockworkTool(entity);
        if (!stack.m_41619_() && WindingGearsAugment.isClockworkTool(entity.m_6844_(EquipmentSlot.FEET))) {
            double spoolCost = Math.max(0.0f, event.getDistance() - 1.0f) * 5.0f;
            if (WindingGearsAugment.getCharge(entity.m_9236_(), stack) >= spoolCost) {
                event.setDamageMultiplier(0.0f);
                if (entity.m_20184_().f_82480_ < -0.5) {
                    if (!entity.m_9236_().m_5776_()) {
                        WindingGearsAugment.depleteCharge(entity.m_9236_(), stack, spoolCost);
                    }
                    bounceLocal.get().put((Entity)entity, -entity.m_20184_().f_82480_);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttack(LivingDamageEvent event) {
        LivingEntity player;
        ItemStack mainStack;
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && WindingGearsAugment.isClockworkTool(mainStack = (player = (LivingEntity)entity).m_21205_())) {
            double charge = WindingGearsAugment.getCharge(player.m_9236_(), mainStack);
            double cost = 5.0;
            if (charge >= WindingGearsAugment.getMaxCharge(player.m_9236_(), mainStack)) {
                cost = charge;
            }
            if (!player.m_9236_().m_5776_()) {
                WindingGearsAugment.depleteCharge(player.m_9236_(), mainStack, cost);
            }
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        double charge;
        Player player = event.getEntity();
        ItemStack mainStack = player.m_21205_();
        float speed = event.getNewSpeed();
        if (WindingGearsAugment.isClockworkTool(mainStack) && (charge = WindingGearsAugment.getCharge(player.m_9236_(), mainStack)) > 0.0) {
            event.setNewSpeed(Math.max(Math.min(speed, 0.1f), speed + WindingGearsAugment.getSpeedBonus(player.m_9236_(), mainStack)));
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        double charge;
        ItemStack mainStack;
        Player player = event.getPlayer();
        if (!event.isCanceled() && player != null && WindingGearsAugment.isClockworkTool(mainStack = player.m_21205_()) && (charge = WindingGearsAugment.getCharge(player.m_9236_(), mainStack)) > 0.0 && !player.m_9236_().m_5776_()) {
            WindingGearsAugment.depleteCharge(player.m_9236_(), mainStack, 40.0);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (WindingGearsAugment.isClockworkTool(stack)) {
            int level = WindingGearsAugment.getClockworkLevel(stack);
            double maxCharge = WindingGearsAugment.getMaxCharge(player.m_9236_(), stack);
            if (level > 0) {
                double resonance = EmbersAPI.getEmberResonance(stack);
                double charge = WindingGearsAugment.getCharge(player.m_9236_(), stack);
                double addAmount = Math.max((0.025 + 0.01 * (double)level) * (maxCharge - charge), 5.0 * resonance);
                WindingGearsAugment.addCharge(player.m_9236_(), stack, addAmount);
                player.m_6674_(event.getHand());
                event.setCancellationResult(InteractionResult.PASS);
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack;
            ++ticks;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null && !(stack = WindingGearsAugment.getHeldClockworkTool((LivingEntity)player)).m_41619_()) {
                EntityHitResult entityHit;
                HitResult hitResult;
                spoolLast = spool;
                spool = (int)(720.0 * WindingGearsAugment.getCharge(player.m_9236_(), stack) / 500.0);
                angleLast = angle;
                angle += WindingGearsAugment.getRotationSpeed(player.m_9236_(), stack);
                if (mc.f_91066_.f_92096_.m_90857_() && (hitResult = mc.f_91077_) instanceof EntityHitResult && this.canAutoAttack(player, stack, entityHit = (EntityHitResult)hitResult)) {
                    mc.f_91072_.m_105223_((Player)player, entityHit.m_82443_());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean canAutoAttack(LocalPlayer player, ItemStack stack, EntityHitResult objectMouseOver) {
        return player.m_36403_(0.0f) >= 1.0f && WindingGearsAugment.getCharge(player.m_9236_(), stack) > 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isInvulnerable(Entity entity) {
        return entity.m_20147_() || entity instanceof LivingEntity && entity.f_19802_ > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderSpringUnderlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        int fill = (int)((float)spoolLast * (1.0f - partialTicks) + (float)spool * partialTicks);
        fill += 16;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = WindingGearsAugment.getHeldClockworkTool((LivingEntity)player);
        if (!stack.m_41619_()) {
            int x = WindingGearsAugment.getBarX(width);
            int y = WindingGearsAugment.getBarY(height);
            int segs = fill / 32;
            int last = fill % 32;
            int u = 0;
            int v = 40;
            int evenWidth = segs * 8;
            int oddWidth = segs * 8 - 4;
            int evenFillBack = Mth.m_14045_((int)(last - 16), (int)0, (int)8);
            int oddFillBack = Mth.m_14045_((int)(last - 0), (int)0, (int)8);
            graphics.m_280218_(TEXTURE_HUD, x, y, u, v, evenWidth, 8);
            graphics.m_280218_(TEXTURE_HUD, x + evenWidth, y + 8 - evenFillBack, u + evenWidth, v + 8 - evenFillBack, 8, evenFillBack);
            graphics.m_280218_(TEXTURE_HUD, x, y, u, v += 16, oddWidth, 8);
            graphics.m_280218_(TEXTURE_HUD, x + oddWidth, y + 8 - oddFillBack, u + oddWidth, v + 8 - oddFillBack, 8, oddFillBack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderSpringOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        int fill = (int)((float)spoolLast * (1.0f - partialTicks) + (float)spool * partialTicks);
        double currentAngle = angleLast * (double)(1.0f - partialTicks) + angle * (double)partialTicks;
        int gearFrame = (int)(currentAngle * 4.0 / 360.0);
        int uGear = gearFrame % 4 * 10;
        int vGear = 16;
        fill += 16;
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = WindingGearsAugment.getHeldClockworkTool((LivingEntity)player);
        if (!stack.m_41619_()) {
            int x = WindingGearsAugment.getBarX(width);
            int y = WindingGearsAugment.getBarY(height);
            int segs = fill / 32;
            int last = fill % 32;
            int u = 0;
            int v = 32;
            int evenWidth = segs * 8;
            int oddWidth = segs * 8 - 4;
            int evenFillFront = Mth.m_14045_((int)(last - 24), (int)0, (int)8);
            int oddFillFront = Mth.m_14045_((int)(last - 8), (int)0, (int)8);
            graphics.m_280218_(TEXTURE_HUD, x - 9, y - 1, uGear, vGear, 10, 10);
            graphics.m_280218_(TEXTURE_HUD, x, y, u, v, evenWidth, 8);
            graphics.m_280218_(TEXTURE_HUD, x + evenWidth, y, u + evenWidth, v, 8, evenFillFront);
            graphics.m_280218_(TEXTURE_HUD, x, y, u, v += 16, oddWidth, 8);
            graphics.m_280218_(TEXTURE_HUD, x + oddWidth, y, u + oddWidth, v, 8, oddFillFront);
        }
    }

    static {
        bounceLocal = ThreadLocal.withInitial(WeakHashMap::new);
    }
}

