/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.DialBaseBlock;
import com.rekindled.embers.blockentity.FluidDialBlockEntity;
import com.rekindled.embers.datagen.EmbersFluidTags;
import com.rekindled.embers.util.FluidAmounts;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidDialBlock
extends DialBaseBlock {
    public static final String DIAL_TYPE = "fluid";

    public FluidDialBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        IFluidHandler cap;
        BlockEntity blockEntity = level.m_7702_(pos.m_5484_((Direction)state.m_61143_((Property)f_52588_), -1));
        if (blockEntity != null && (cap = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, ((Direction)state.m_61143_((Property)f_52588_)).m_122424_()).orElse((Object)((IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)))) != null) {
            int totalCapacity = 0;
            int totalContents = 0;
            for (int i = 0; i < cap.getTanks(); ++i) {
                totalCapacity += cap.getTankCapacity(i);
                totalContents += cap.getFluidInTank(i).getAmount();
            }
            if (totalContents >= totalCapacity) {
                return 15;
            }
            return (int)Math.ceil(14.0 * (double)totalContents / (double)totalCapacity);
        }
        return 0;
    }

    @Override
    protected void getBEData(Direction facing, ArrayList<Component> text, BlockEntity blockEntity, int maxLines) {
        if (blockEntity instanceof FluidDialBlockEntity) {
            FluidDialBlockEntity dial = (FluidDialBlockEntity)blockEntity;
            if (dial.display) {
                int extraLines = 0;
                for (int i = 0; i < dial.fluids.length && i + extraLines < maxLines; ++i) {
                    FluidStack contents = dial.fluids[i];
                    text.add((Component)FluidDialBlock.formatFluidStack(contents, dial.capacities[i]));
                    if (!contents.getFluid().m_205067_(EmbersFluidTags.INGOT_TOOLTIP) || contents.getAmount() < FluidAmounts.nuggetValue()) continue;
                    if (i + extraLines + 1 < maxLines) {
                        text.add((Component)FluidAmounts.getIngotTooltip(contents.getAmount()));
                    }
                    ++extraLines;
                }
                if (dial.fluids.length + dial.extraLines + extraLines > Math.min(maxLines, dial.fluids.length + extraLines)) {
                    text.add((Component)Component.m_237110_((String)"embers.tooltip.too_many", (Object[])new Object[]{dial.fluids.length + extraLines - Math.min(maxLines, dial.fluids.length + extraLines) + dial.extraLines}));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent formatFluidStack(FluidStack contents, int capacity) {
        if (!contents.isEmpty()) {
            return Component.m_237110_((String)"embers.tooltip.fluiddial.fluid", (Object[])new Object[]{contents.getDisplayName().getString(), contents.getAmount(), capacity});
        }
        return Component.m_237110_((String)"embers.tooltip.fluiddial.nofluid", (Object[])new Object[]{capacity});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.FLUID_DIAL_ENTITY.get()).m_155264_(pPos, pState);
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }
}

