/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.power.IEmberPacketProducer;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.ISparkable;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.damage.DamageEmber;
import com.rekindled.embers.datagen.EmbersDamageTypes;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageBeamCannonFX;
import com.rekindled.embers.power.DefaultEmberCapability;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class BeamCannonBlockEntity
extends BlockEntity
implements IUpgradeable,
IEmberPacketProducer,
IExtraCapabilityInformation {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            BeamCannonBlockEntity.this.m_6596_();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    public static final double PULL_RATE = 2000.0;
    public static final int FIRE_THRESHOLD = 1000;
    public static final float DAMAGE = 25.0f;
    public static final int MAX_DISTANCE = 64;
    public long ticksExisted = 0L;
    public boolean lastPowered = false;
    public Random random = new Random();
    public int offset = this.random.nextInt(40);
    protected List<UpgradeContext> upgrades = new LinkedList<UpgradeContext>();

    public BeamCannonBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.BEAM_CANNON_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(2000.0);
    }

    public BeamCannonBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.lastPowered = nbt.m_128471_("lastPowered");
        this.capability.deserializeNBT((Tag)nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("lastPowered", this.lastPowered);
        this.capability.writeToNBT(nbt);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BeamCannonBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BeamCannonBlockEntity blockEntity) {
        IEmberCapability cap;
        ++blockEntity.ticksExisted;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity attachedTile = level.m_7702_(pos.m_5484_(facing, -1));
        if (blockEntity.ticksExisted % 5L == 0L && attachedTile != null && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing).orElse(null)) != null && cap.getEmber() > 0.0 && blockEntity.capability.getEmber() < blockEntity.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(2000.0, true);
            blockEntity.capability.addAmount(removed, true);
        }
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Direction.values());
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        boolean cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
        boolean isPowered = level.m_276867_(pos);
        boolean redstoneEnabled = UpgradeUtil.getOtherParameter((BlockEntity)blockEntity, "redstone_enabled", true, blockEntity.upgrades);
        int threshold = UpgradeUtil.getOtherParameter((BlockEntity)blockEntity, "fire_threshold", 1000, blockEntity.upgrades);
        if (!cancel && blockEntity.capability.getEmber() >= (double)threshold && (!redstoneEnabled || isPowered && !blockEntity.lastPowered)) {
            blockEntity.fire(facing);
        }
        blockEntity.lastPowered = isPowered;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY && this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_) != side) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public void fire(Direction facing) {
        Vec3 ray = new Vec3((double)facing.m_122436_().m_123341_(), (double)facing.m_122436_().m_123342_(), (double)facing.m_122436_().m_123343_());
        double damage = UpgradeUtil.getOtherParameter((BlockEntity)this, "damage", 25.0, this.upgrades);
        boolean doContinue = true;
        int maxDist = UpgradeUtil.getOtherParameter((BlockEntity)this, "distance", 64, this.upgrades);
        double impactDist = maxDist;
        BlockPos hitPos = this.f_58858_;
        for (int i = 0; i < maxDist && doContinue; ++i) {
            hitPos = hitPos.m_121945_(facing);
            BlockState state = this.f_58857_.m_8055_(hitPos);
            BlockEntity tile = this.f_58857_.m_7702_(hitPos);
            if (this.sparkTarget(tile)) {
                doContinue = false;
                impactDist = i + 1;
            } else if (tile instanceof IEmberPacketReceiver) {
                IEmberCapability cap = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null).orElse(null);
                if (cap != null) {
                    cap.addAmount(this.capability.getEmber(), true);
                }
                doContinue = false;
                impactDist = i + 1;
            } else if (!state.m_60812_((BlockGetter)this.f_58857_, hitPos).m_83281_()) {
                doContinue = false;
                impactDist = (double)i + 0.5;
            }
            if (doContinue) continue;
            this.f_58857_.m_5594_(null, hitPos, (SoundEvent)EmbersSounds.BEAM_CANNON_HIT.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        List entities = this.f_58857_.m_6249_((Entity)null, new AABB(this.f_58858_.m_252807_(), hitPos.m_252807_()), EntitySelector.f_20408_);
        for (Entity entity : entities) {
            DamageEmber damageSource = new DamageEmber((Holder<DamageType>)((Registry)this.f_58857_.m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(EmbersDamageTypes.EMBER_KEY), this.f_58858_.m_252807_());
            entity.m_6469_((DamageSource)damageSource, (float)damage);
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new MessageBeamCannonFX((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, ray.f_82479_ * impactDist, ray.f_82480_ * impactDist, ray.f_82481_ * impactDist));
        UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.TRANSFER, this.capability.getEmber()), this.upgrades);
        this.capability.setEmber(0.0);
        this.m_6596_();
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)EmbersSounds.BEAM_CANNON_FIRE.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
    }

    public boolean sparkTarget(BlockEntity target) {
        if (target instanceof ISparkable) {
            ((ISparkable)target).sparkProgress(this, this.capability.getEmber());
            return true;
        }
        return false;
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return true;
    }

    @Override
    public Vec3 getEmittingDirection(Direction side) {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return new Vec3((double)facing.m_122436_().m_123341_(), (double)facing.m_122436_().m_123342_(), (double)facing.m_122436_().m_123343_());
        }
        return null;
    }

    @Override
    public BlockPos getTarget(Direction side) {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            if (side != facing) {
                return null;
            }
            int maxDist = UpgradeUtil.getOtherParameter((BlockEntity)this, "distance", 64, this.upgrades);
            BlockPos hitPos = this.f_58858_;
            for (int i = 0; i < maxDist; ++i) {
                hitPos = hitPos.m_121945_(facing);
                BlockState hitState = this.f_58857_.m_8055_(hitPos);
                BlockEntity tile = this.f_58857_.m_7702_(hitPos);
                if (!(tile instanceof ISparkable) && !(tile instanceof IEmberPacketReceiver) && hitState.m_60812_((BlockGetter)this.f_58857_, hitPos).m_83281_()) continue;
                return hitPos;
            }
            return hitPos;
        }
        return null;
    }

    @Override
    public void addOtherDescription(List<Component> strings, Direction facing) {
        strings.add((Component)Component.m_237115_((String)"embers.tooltip.goggles.redstone_signal"));
    }
}

