/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.VaporParticleOptions;
import com.rekindled.embers.recipe.IGaseousFuelRecipe;
import com.rekindled.embers.upgrade.CatalyticPlugUpgrade;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.joml.Vector3f;

public class CatalyticPlugBlockEntity
extends BlockEntity
implements ISoundController,
IExtraCapabilityInformation {
    public static final int SOUND_OFF = 1;
    public static final int SOUND_ON = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    int ticksExisted = 0;
    public float renderOffset;
    int previousFluid;
    public int activeTicks = 0;
    public int burnTime = 0;
    public CatalyticPlugUpgrade upgrade;
    public FluidTank tank = new FluidTank(4000){

        public void onContentsChanged() {
            CatalyticPlugBlockEntity.this.m_6596_();
        }
    };
    private static Random random = new Random();
    public IGaseousFuelRecipe cachedRecipe = null;
    HashSet<Integer> soundsPlaying = new HashSet();
    public LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public CatalyticPlugBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.CATALYTIC_PLUG_ENTITY.get(), pPos, pBlockState);
        this.upgrade = new CatalyticPlugUpgrade(this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.activeTicks = nbt.m_128451_("active");
        this.burnTime = nbt.m_128451_("burnTime");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128405_("active", this.activeTicks);
        nbt.m_128405_("burnTime", this.burnTime);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128405_("active", this.activeTicks);
        nbt.m_128405_("burnTime", this.burnTime);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void setActive(int ticks) {
        this.activeTicks = Math.max(ticks, this.activeTicks);
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CatalyticPlugBlockEntity blockEntity) {
        --blockEntity.activeTicks;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CatalyticPlugBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        if (blockEntity.ticksExisted == 1) {
            blockEntity.previousFluid = blockEntity.tank.getFluidAmount();
        }
        if (blockEntity.tank.getFluidAmount() != blockEntity.previousFluid) {
            blockEntity.renderOffset = blockEntity.renderOffset + (float)blockEntity.tank.getFluidAmount() - (float)blockEntity.previousFluid;
            blockEntity.previousFluid = blockEntity.tank.getFluidAmount();
        }
        blockEntity.handleSound();
        --blockEntity.activeTicks;
        if (blockEntity.activeTicks > 0 && state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            float yoffset = 0.38f;
            float wideoffset = 0.45f;
            Vec3 baseOffset = new Vec3(0.5 - (double)((float)facing.m_122436_().m_123341_() * yoffset), 0.5 - (double)((float)facing.m_122436_().m_123342_() * yoffset), 0.5 - (double)((float)facing.m_122436_().m_123343_() * yoffset));
            Direction[] planars = switch (facing.m_122434_()) {
                case Direction.Axis.X -> new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};
                case Direction.Axis.Y -> new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};
                case Direction.Axis.Z -> new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST};
                default -> null;
            };
            Vector3f color = IClientFluidTypeExtensions.of((FluidType)blockEntity.tank.getFluid().getFluid().getFluidType()).modifyFogColor(Minecraft.m_91087_().f_91063_.m_109153_(), 0.0f, (ClientLevel)level, 6, 0.0f, new Vector3f(1.0f, 1.0f, 1.0f));
            for (Direction planar : planars) {
                BlockState sideState = level.m_8055_(pos.m_121945_(planar));
                if (!sideState.m_60655_((BlockGetter)level, pos.m_121945_(planar), planar.m_122424_()).m_83281_()) continue;
                float x = (float)pos.m_123341_() + (float)baseOffset.f_82479_ + (float)planar.m_122436_().m_123341_() * wideoffset;
                float y = (float)pos.m_123342_() + (float)baseOffset.f_82480_ + (float)planar.m_122436_().m_123342_() * wideoffset;
                float z = (float)pos.m_123343_() + (float)baseOffset.f_82481_ + (float)planar.m_122436_().m_123343_() * wideoffset;
                float motionx = (float)planar.m_122436_().m_123341_() * 0.053f - (float)facing.m_122436_().m_123341_() * 0.015f - 0.01f + random.nextFloat() * 0.02f;
                float motiony = (float)planar.m_122436_().m_123342_() * 0.053f - (float)facing.m_122436_().m_123342_() * 0.015f - 0.01f + random.nextFloat() * 0.02f;
                float motionz = (float)planar.m_122436_().m_123343_() * 0.053f - (float)facing.m_122436_().m_123343_() * 0.015f - 0.01f + random.nextFloat() * 0.02f;
                level.m_7106_((ParticleOptions)new VaporParticleOptions(color, new Vec3((double)motionx, (double)motiony, (double)motionz), 1.25f), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_);
            if (cap == ForgeCapabilities.FLUID_HANDLER && (side == null || side == facing)) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.holder);
            }
            if (cap == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && (side == null || side.m_122424_() == facing)) {
                return this.upgrade.getCapability(cap, side);
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
        this.upgrade.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.f_58858_.m_123341_() + 0.5f;
        float soundY = (float)this.f_58858_.m_123342_() + 0.5f;
        float soundZ = (float)this.f_58858_.m_123343_() + 0.5f;
        switch (id) {
            case 2: {
                EmbersSounds.playMachineSound(this, 2, (SoundEvent)EmbersSounds.CATALYTIC_PLUG_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.f_58857_.m_7785_((double)soundX, (double)soundY, (double)soundZ, (SoundEvent)EmbersSounds.CATALYTIC_PLUG_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.CATALYTIC_PLUG_LOOP_READY.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        if (id == 2) {
            this.f_58857_.m_245747_(this.f_58858_, (SoundEvent)EmbersSounds.CATALYTIC_PLUG_STOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        boolean isWorking = this.activeTicks > 0;
        switch (id) {
            case 1: {
                return !isWorking && this.tank.getFluidAmount() > 0;
            }
            case 2: {
                return isWorking;
            }
        }
        return false;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        boolean isWorking = this.activeTicks > 0;
        switch (id) {
            case 1: {
                return !isWorking ? 1.0f : 0.0f;
            }
            case 2: {
                return isWorking ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.FLUID_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", (Component)Component.m_237115_((String)"embers.tooltip.goggles.fluid.steam")));
        }
    }
}

