/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.MachineRecipeEvent;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IMechanicallyPowered;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.recipe.BoringContext;
import com.rekindled.embers.recipe.IBoringRecipe;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.WeightedItemStack;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EmberBoreBlockEntity
extends BlockEntity
implements ISoundController,
IMechanicallyPowered,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static final int SLOT_FUEL = 8;
    public static final double SUPERSPEED_THRESHOLD = 2.5;
    public static final int SOUND_ON = 1;
    public static final int SOUND_ON_DRILL = 2;
    public static final int SOUND_ON_SUPERSPEED = 3;
    public static final int SOUND_ON_DRILL_SUPERSPEED = 4;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3, 4};
    Random random = new Random();
    public long ticksExisted = 0L;
    public float angle = 0.0f;
    public double ticksFueled = 0.0;
    public float lastAngle;
    public boolean isRunning;
    HashSet<Integer> soundsPlaying = new HashSet();
    public List<UpgradeContext> upgrades = new ArrayList<UpgradeContext>();
    public double speedMod;
    public EmberBoreInventory inventory = new EmberBoreInventory(9);
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    Boolean canMine = null;

    public EmberBoreBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_BORE_ENTITY.get(), pPos, pBlockState);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, -2, -1), this.f_58858_.m_7918_(2, 0, 2));
    }

    public AABB getBladeBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, -2, -1), this.f_58858_.m_7918_(1, -1, 1));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
        if (nbt.m_128441_("fueled")) {
            this.ticksFueled = nbt.m_128459_("fueled");
        }
        this.isRunning = nbt.m_128471_("isRunning");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128347_("fueled", this.ticksFueled);
        nbt.m_128379_("isRunning", this.isRunning);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("isRunning", this.isRunning);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean canMine() {
        if (this.canMine == null) {
            ResourceKey biome = (ResourceKey)this.f_58857_.m_204166_(this.f_58858_).m_203543_().get();
            if (biome != null) {
                BoringContext context = new BoringContext(this.f_58857_.m_46472_().m_135782_(), biome.m_135782_(), this.f_58858_.m_123342_(), (BlockState[])this.f_58857_.m_46847_(this.getBladeBoundingBox()).toArray(BlockState[]::new));
                List recipes = this.f_58857_.m_7465_().m_44056_((RecipeType)RegistryManager.BORING.get(), (Container)context, this.f_58857_);
                UpgradeUtil.throwEvent(this, new MachineRecipeEvent<List>(this, recipes), this.upgrades);
                this.canMine = !recipes.isEmpty();
            } else {
                this.canMine = false;
            }
        }
        return this.canMine;
    }

    public boolean isSuperSpeed() {
        return this.speedMod >= 2.5;
    }

    public boolean canInsert(ArrayList<ItemStack> returns) {
        Iterator<ItemStack> iterator = returns.iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            ItemStack returned = stack = iterator.next();
            for (int slot = 0; slot < this.inventory.getSlots() - 1; ++slot) {
                returned = this.inventory.insertItemInternal(slot, returned, true);
            }
            if (returned.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void insert(ArrayList<ItemStack> returns) {
        Iterator<ItemStack> iterator = returns.iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            ItemStack returned = stack = iterator.next();
            for (int slot = 0; slot < this.inventory.getSlots() - 1; ++slot) {
                returned = this.inventory.insertItemInternal(slot, returned, false);
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberBoreBlockEntity blockEntity) {
        EmberBoreBlockEntity.commonTick(level, pos, state, blockEntity);
        boolean previousRunning = blockEntity.isRunning;
        blockEntity.isRunning = false;
        ++blockEntity.ticksExisted;
        double fuelConsumption = UpgradeUtil.getOtherParameter((BlockEntity)blockEntity, "fuel_consumption", ((Double)ConfigManager.EMBER_BORE_FUEL_CONSUMPTION.get()).doubleValue(), blockEntity.upgrades);
        boolean cancel = false;
        if (blockEntity.ticksFueled >= fuelConsumption) {
            blockEntity.isRunning = true;
            blockEntity.ticksFueled -= fuelConsumption;
            cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades);
        } else {
            blockEntity.ticksFueled = 0.0;
        }
        if (!cancel) {
            if (blockEntity.ticksFueled < fuelConsumption) {
                ItemStack fuelCopy;
                int burnTime;
                ItemStack fuel = blockEntity.inventory.getStackInSlot(8);
                if (!fuel.m_41619_() && (burnTime = ForgeHooks.getBurnTime((ItemStack)(fuelCopy = fuel.m_41777_()), (RecipeType)((RecipeType)RegistryManager.BORING.get()))) > 0) {
                    blockEntity.ticksFueled = burnTime;
                    fuel.m_41774_(1);
                    if (fuel.m_41619_()) {
                        blockEntity.inventory.setStackInSlot(8, fuelCopy.m_41720_().getCraftingRemainingItem(fuelCopy));
                    }
                    blockEntity.m_6596_();
                }
            } else {
                ResourceKey biome;
                int boreTime = (int)Math.ceil((double)((Integer)ConfigManager.EMBER_BORE_TIME.get()).intValue() / (blockEntity.speedMod * (Double)ConfigManager.EMBER_BORE_SPEED_MOD.get()));
                if (blockEntity.ticksExisted % (long)boreTime == 0L && (biome = (ResourceKey)level.m_204166_(pos).m_203543_().get()) != null) {
                    BoringContext context = new BoringContext(level.m_46472_().m_135782_(), biome.m_135782_(), pos.m_123342_(), (BlockState[])level.m_46847_(blockEntity.getBladeBoundingBox()).toArray(BlockState[]::new));
                    List recipes = level.m_7465_().m_44056_((RecipeType)RegistryManager.BORING.get(), (Container)context, level);
                    UpgradeUtil.throwEvent(blockEntity, new MachineRecipeEvent<List>(blockEntity, recipes), blockEntity.upgrades);
                    ArrayList<WeightedItemStack> stacks = new ArrayList<WeightedItemStack>();
                    float rand = blockEntity.random.nextFloat();
                    double chance = EmberGenUtil.getEmberDensity(((ServerLevel)level).m_7328_(), pos.m_123341_(), pos.m_123343_());
                    for (IBoringRecipe recipe : recipes) {
                        double d = rand;
                        double d2 = recipe.getChance() == -1.0 ? chance : recipe.getChance();
                        if (!(d < d2)) continue;
                        stacks.add(recipe.getOutput(context));
                    }
                    ArrayList<ItemStack> returns = new ArrayList<ItemStack>();
                    if (!stacks.isEmpty()) {
                        Optional picked = WeightedRandom.m_216822_((RandomSource)level.m_213780_(), stacks);
                        returns.add(((WeightedItemStack)((Object)picked.get())).getStack().m_41777_());
                    }
                    UpgradeUtil.transformOutput((BlockEntity)blockEntity, returns, blockEntity.upgrades);
                    if (blockEntity.canInsert(returns)) {
                        blockEntity.insert(returns);
                    }
                }
            }
        } else {
            blockEntity.isRunning = false;
        }
        if (blockEntity.isRunning != previousRunning) {
            blockEntity.m_6596_();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EmberBoreBlockEntity blockEntity) {
        EmberBoreBlockEntity.commonTick(level, pos, state, blockEntity);
        blockEntity.handleSound();
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, EmberBoreBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, new Direction[]{Direction.UP});
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        blockEntity.speedMod = UpgradeUtil.getTotalSpeedModifier(blockEntity, blockEntity.upgrades);
        blockEntity.lastAngle = blockEntity.angle;
        if (blockEntity.isRunning) {
            blockEntity.angle = (float)((double)blockEntity.angle + 12.0 * blockEntity.speedMod);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!(this.f_58859_ || side != null && side != Direction.UP || cap != ForgeCapabilities.ITEM_HANDLER)) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.f_58858_.m_123341_() + 0.5f;
        float soundY = (float)this.f_58858_.m_123342_() - 0.5f;
        float soundZ = (float)this.f_58858_.m_123343_() + 0.5f;
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.BORE_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 2: {
                EmbersSounds.playMachineSound(this, 2, (SoundEvent)EmbersSounds.BORE_LOOP_MINE.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 3: {
                EmbersSounds.playMachineSound(this, 3, (SoundEvent)EmbersSounds.BORE_LOOP_SUPERSPEED.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 4: {
                EmbersSounds.playMachineSound(this, 4, (SoundEvent)EmbersSounds.BORE_LOOP_MINE_SUPERSPEED.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.f_58857_.m_7785_((double)soundX, (double)soundY, (double)soundZ, (SoundEvent)EmbersSounds.BORE_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.f_58857_.m_7785_((double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() - 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), (SoundEvent)EmbersSounds.BORE_STOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        switch (id) {
            case 1: {
                return this.isRunning && !this.canMine() && !this.isSuperSpeed();
            }
            case 2: {
                return this.isRunning && this.canMine() && !this.isSuperSpeed();
            }
            case 3: {
                return this.isRunning && !this.canMine() && this.isSuperSpeed();
            }
            case 4: {
                return this.isRunning && this.canMine() && this.isSuperSpeed();
            }
        }
        return false;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        switch (id) {
            case 1: {
                return !this.canMine() && !this.isSuperSpeed() ? 1.0f : 0.0f;
            }
            case 2: {
                return this.canMine() && !this.isSuperSpeed() ? 1.0f : 0.0f;
            }
            case 3: {
                return !this.canMine() && this.isSuperSpeed() ? 1.0f : 0.0f;
            }
            case 4: {
                return this.canMine() && this.isSuperSpeed() ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getCurrentPitch(int id, float pitch) {
        if (this.isSuperSpeed()) {
            return (float)(this.speedMod + 1.0 - 2.5);
        }
        return (float)this.speedMod;
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return power > 0.0 ? Math.log10(power / 15.0) * 3.0 : 0.0;
    }

    @Override
    public double getMinimumPower() {
        return 15.0;
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.fuel")));
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ember")));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face == Direction.UP;
    }

    public class EmberBoreInventory
    extends ItemStackHandler {
        public EmberBoreInventory() {
        }

        public EmberBoreInventory(int size) {
            super(size);
        }

        public EmberBoreInventory(NonNullList<ItemStack> stacks) {
            super(stacks);
        }

        protected void onContentsChanged(int slot) {
            EmberBoreBlockEntity.this.m_6596_();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack currentFuel = this.getStackInSlot(8);
            if (currentFuel.m_41619_()) {
                int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)((RecipeType)RegistryManager.BORING.get()));
                if (burnTime != 0) {
                    return super.insertItem(8, stack, simulate);
                }
                return stack;
            }
            return super.insertItem(8, stack, simulate);
        }

        public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack fuelStack;
            if (slot == 8 && ((fuelStack = this.getStackInSlot(8)).m_41613_() > 1 || ForgeHooks.getBurnTime((ItemStack)fuelStack, (RecipeType)((RecipeType)RegistryManager.BORING.get())) != 0)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

