/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.power.IEmberPacketProducer;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.api.power.ITargetable;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberPacketEntity;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.Misc;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EmberEmitterBlockEntity
extends BlockEntity
implements IEmberPacketProducer,
ITargetable,
IExtraCapabilityInformation {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            EmberEmitterBlockEntity.this.m_6596_();
        }

        @Override
        public boolean acceptsVolatile() {
            return false;
        }
    };
    public static final double TRANSFER_RATE = 40.0;
    public static final double PULL_RATE = 10.0;
    public BlockPos target = null;
    public long ticksExisted = 0L;
    public Random random = new Random();
    public int offset = this.random.nextInt(40);
    public HashSet<ChunkPos> trajectoryChunks = null;

    public EmberEmitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_EMITTER_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(200.0);
        this.capability.setEmber(0.0);
    }

    public EmberEmitterBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("targetX")) {
            this.target = new BlockPos(nbt.m_128451_("targetX"), nbt.m_128451_("targetY"), nbt.m_128451_("targetZ"));
        }
        this.capability.deserializeNBT((Tag)nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.target != null) {
            nbt.m_128405_("targetX", this.target.m_123341_());
            nbt.m_128405_("targetY", this.target.m_123342_());
            nbt.m_128405_("targetZ", this.target.m_123343_());
        }
        this.capability.writeToNBT(nbt);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.target != null) {
            nbt.m_128405_("targetX", this.target.m_123341_());
            nbt.m_128405_("targetY", this.target.m_123342_());
            nbt.m_128405_("targetZ", this.target.m_123343_());
        }
        return nbt;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
        if (this.trajectoryChunks == null) {
            this.trajectoryChunks = new HashSet();
        }
        Misc.calculateTrajectoryChunks(this.trajectoryChunks, this.f_58858_, this.target, this.getEmittingDirection((Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberEmitterBlockEntity blockEntity) {
        BlockEntity targetTile;
        IEmberCapability cap;
        ++blockEntity.ticksExisted;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity attachedTile = level.m_7702_(pos.m_5484_(facing, -1));
        if (blockEntity.ticksExisted % 5L == 0L && attachedTile != null && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing).orElse(null)) != null && cap.getEmber() > 0.0 && blockEntity.capability.getEmber() < blockEntity.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(10.0, true);
            blockEntity.capability.addAmount(removed, true);
        }
        if ((blockEntity.ticksExisted + (long)blockEntity.offset) % 20L == 0L && blockEntity.canSendBurst() && blockEntity.capability.getEmber() > 10.0 && (targetTile = level.m_7702_(blockEntity.target)) instanceof IEmberPacketReceiver && ((IEmberPacketReceiver)targetTile).hasRoomFor(40.0)) {
            EmberPacketEntity packet = (EmberPacketEntity)((EntityType)RegistryManager.EMBER_PACKET.get()).m_20615_(blockEntity.f_58857_);
            Vec3 velocity = EmberEmitterBlockEntity.getBurstVelocity(facing);
            packet.initCustom(pos, blockEntity.target, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, Math.min(40.0, blockEntity.capability.getEmber()));
            blockEntity.capability.removeAmount(Math.min(40.0, blockEntity.capability.getEmber()), true);
            blockEntity.f_58857_.m_7967_((Entity)packet);
            level.m_5594_(null, pos, (SoundEvent)EmbersSounds.EMBER_EMIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean canSendBurst() {
        if (this.f_58857_.m_276867_(this.f_58858_) && this.target != null && this.f_58857_.m_46749_(this.target) && !this.f_58857_.f_46443_) {
            Object object;
            if (this.trajectoryChunks == null) {
                this.trajectoryChunks = new HashSet();
                Misc.calculateTrajectoryChunks(this.trajectoryChunks, this.f_58858_, this.target, this.getEmittingDirection((Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_)));
            }
            if ((object = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                for (ChunkPos chunk : this.trajectoryChunks) {
                    if (serverLevel.m_201916_(chunk)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Vec3 getBurstVelocity(Direction facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3(0.0, -0.5, 0.0);
            }
            case UP: {
                return new Vec3(0.0, 0.5, 0.0);
            }
            case NORTH: {
                return new Vec3(0.0, -0.01, -0.5);
            }
            case SOUTH: {
                return new Vec3(0.0, -0.01, 0.5);
            }
            case WEST: {
                return new Vec3(-0.5, -0.01, 0.0);
            }
            case EAST: {
                return new Vec3(0.5, -0.01, 0.0);
            }
        }
        return Vec3.f_82478_;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY && this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)BlockStateProperties.f_61372_) != side) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    @Override
    public void setTargetPosition(BlockPos pos, Direction side) {
        this.target = pos;
        this.m_6596_();
    }

    @Override
    public Vec3 getEmittingDirection(Direction side) {
        return EmberEmitterBlockEntity.getBurstVelocity((Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_));
    }

    @Override
    public BlockPos getTarget(Direction side) {
        Direction facing;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BlockStateProperties.f_61372_) && side != (facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))) {
            return null;
        }
        return this.target;
    }

    @Override
    public void addOtherDescription(List<Component> strings, Direction facing) {
        strings.add((Component)Component.m_237115_((String)"embers.tooltip.goggles.redstone_signal"));
    }
}

