/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.IUpgradeProxy;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.util.Misc;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MechanicalCoreBlockEntity
extends BlockEntity
implements IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeProxy {
    public MechanicalCoreBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.MECHANICAL_CORE_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    public BlockEntityDirection getAttachedMultiblock(int distanceLeft) {
        if (distanceLeft < 1) {
            return null;
        }
        BlockPos sidePos = this.f_58858_.m_121945_(this.getAttachedSide());
        if (Misc.isSideProxyable(this.f_58857_.m_8055_(sidePos), this.f_58857_.m_7702_(sidePos), this.getFace())) {
            return new BlockEntityDirection(this.f_58857_.m_7702_(sidePos), this.getFace());
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(sidePos);
        if (blockEntity instanceof IUpgradeProxy) {
            IUpgradeProxy proxy = (IUpgradeProxy)blockEntity;
            return proxy.getAttachedMultiblock(distanceLeft - 1);
        }
        return null;
    }

    @Override
    public BlockEntity getAttachedBlockEntity(int distanceLeft) {
        if (distanceLeft < 1) {
            return null;
        }
        BlockPos sidePos = this.f_58858_.m_121945_(this.getAttachedSide());
        if (Misc.isSideProxyable(this.f_58857_.m_8055_(sidePos), this.f_58857_.m_7702_(sidePos), this.getFace())) {
            return this.f_58857_.m_7702_(sidePos);
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(sidePos);
        if (blockEntity instanceof IUpgradeProxy) {
            IUpgradeProxy proxy = (IUpgradeProxy)blockEntity;
            return proxy.getAttachedBlockEntity(distanceLeft - 1);
        }
        return null;
    }

    public Direction getAttachedSide() {
        return this.getFace().m_122424_();
    }

    public Direction getFace() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        BlockEntityDirection multiblock = this.getAttachedMultiblock((Integer)ConfigManager.MAX_PROXY_DISTANCE.get());
        if (multiblock != null) {
            return multiblock.blockEntity.getCapability(cap, multiblock.direction);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        BlockEntityDirection multiblock = this.getAttachedMultiblock((Integer)ConfigManager.MAX_PROXY_DISTANCE.get());
        if (multiblock != null) {
            IUpgradeable upgradeable;
            BlockEntity blockEntity = multiblock.blockEntity;
            return blockEntity instanceof IUpgradeable && (upgradeable = (IUpgradeable)blockEntity).isSideUpgradeSlot(multiblock.direction);
        }
        return false;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        BlockEntityDirection multiblock = this.getAttachedMultiblock((Integer)ConfigManager.MAX_PROXY_DISTANCE.get());
        if (multiblock != null && multiblock.blockEntity instanceof IExtraDialInformation) {
            ((IExtraDialInformation)multiblock.blockEntity).addDialInformation(multiblock.direction, information, dialType);
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        BlockEntity multiblock = this.getAttachedBlockEntity((Integer)ConfigManager.MAX_PROXY_DISTANCE.get());
        if (multiblock instanceof IExtraCapabilityInformation) {
            return ((IExtraCapabilityInformation)multiblock).hasCapabilityDescription(capability);
        }
        return false;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        BlockEntityDirection multiblock = this.getAttachedMultiblock((Integer)ConfigManager.MAX_PROXY_DISTANCE.get());
        if (multiblock != null && multiblock.blockEntity instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)multiblock.blockEntity).addCapabilityDescription(strings, capability, multiblock.direction);
        }
    }

    @Override
    public void addOtherDescription(List<Component> strings, Direction facing) {
        BlockEntityDirection multiblock = this.getAttachedMultiblock((Integer)ConfigManager.MAX_PROXY_DISTANCE.get());
        if (multiblock != null && multiblock.blockEntity instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)multiblock.blockEntity).addOtherDescription(strings, multiblock.direction);
        }
    }

    @Override
    public void collectUpgrades(List<UpgradeContext> upgrades, int distanceLeft) {
        for (Direction facing : Direction.values()) {
            if (!this.isSocket(facing)) continue;
            UpgradeUtil.collectUpgrades(this.f_58857_, this.f_58858_.m_121945_(facing), facing.m_122424_(), upgrades, distanceLeft);
        }
    }

    @Override
    public boolean isSocket(Direction facing) {
        return facing != this.getAttachedSide();
    }

    @Override
    public boolean isProvider(Direction facing) {
        return facing == this.getAttachedSide();
    }

    public static class BlockEntityDirection {
        public BlockEntity blockEntity;
        public Direction direction;

        public BlockEntityDirection(BlockEntity blockEntity, Direction direction) {
            this.blockEntity = blockEntity;
            this.direction = direction;
        }
    }
}

