/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.compat.curios.CuriosCompat;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class EmbersItemModels
extends ItemModelProvider {
    public EmbersItemModels(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "embers", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryManager.FluidStuff fluid : RegistryManager.fluidList) {
            this.bucketModel(fluid.FLUID_BUCKET, (Fluid)fluid.FLUID.get());
        }
        this.itemWithModel(RegistryManager.TINKER_HAMMER, "item/handheld");
        this.basicItem((Item)RegistryManager.TINKER_LENS.get());
        this.basicItem((Item)RegistryManager.SMOKY_TINKER_LENS.get());
        this.basicItem((Item)RegistryManager.ANCIENT_CODEX.get());
        this.layeredItem(RegistryManager.EMBER_JAR, "item/generated", "ember_jar_glass", "ember_jar_glass_shine", "ember_jar");
        this.layeredItem(RegistryManager.EMBER_CARTRIDGE, "item/generated", "ember_cartridge_glass", "ember_cartridge_glass_shine", "ember_cartridge");
        this.layeredItem(CuriosCompat.EMBER_BULB, "item/generated", "ember_bulb_glass", "ember_bulb_glass_shine", "ember_bulb");
        this.itemWithTexture(RegistryManager.MUSIC_DISC_7F_PATTERNS, "music_disc_ember");
        this.basicItem((Item)RegistryManager.ALCHEMICAL_WASTE.get());
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(RegistryManager.ALCHEMICAL_NOTE.getId().m_135815_(), new ResourceLocation("forge", "item/default"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)this.basicItem(new ResourceLocation("embers", "alchemical_note_item"))).perspective(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("builtin/entity"))))).perspective(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("builtin/entity"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("builtin/entity"))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("builtin/entity")))));
        this.basicItem((Item)RegistryManager.CODEBREAKING_SLATE.get());
        this.layeredItem(RegistryManager.TYRFING, "item/handheld", "tyrfing", "tyrfing_gem");
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RegistryManager.INFLICTOR_GEM.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("embers", "item/inflictor_gem"))).override().predicate(new ResourceLocation("embers", "charged"), 1.0f).model((ModelFile)this.singleTexture("inflictor_gem_charged", new ResourceLocation("item/generated"), "layer0", new ResourceLocation("embers", "item/inflictor_gem_charged")));
        this.basicItem((Item)RegistryManager.ASHEN_GOGGLES.get());
        this.basicItem((Item)RegistryManager.ASHEN_CLOAK.get());
        this.basicItem((Item)RegistryManager.ASHEN_LEGGINGS.get());
        this.basicItem((Item)RegistryManager.ASHEN_BOOTS.get());
        this.basicItem((Item)RegistryManager.GLIMMER_CRYSTAL.get());
        this.basicItem((Item)RegistryManager.GLIMMER_LAMP.get());
        this.basicItem((Item)RegistryManager.EMBER_CRYSTAL.get());
        this.basicItem((Item)RegistryManager.EMBER_SHARD.get());
        this.basicItem((Item)RegistryManager.EMBER_GRIT.get());
        this.basicItem((Item)RegistryManager.CAMINITE_BLEND.get());
        this.basicItem((Item)RegistryManager.CAMINITE_BRICK.get());
        this.basicItem((Item)RegistryManager.ARCHAIC_BRICK.get());
        this.basicItem((Item)RegistryManager.ANCIENT_MOTIVE_CORE.get());
        this.basicItem((Item)RegistryManager.ASH.get());
        this.basicItem((Item)RegistryManager.ASHEN_FABRIC.get());
        this.basicItem((Item)RegistryManager.EMBER_CRYSTAL_CLUSTER.get());
        this.basicItem((Item)RegistryManager.WILDFIRE_CORE.get());
        this.basicItem((Item)RegistryManager.ISOLATED_MATERIA.get());
        this.basicItem((Item)RegistryManager.ADHESIVE.get());
        this.basicItem((Item)RegistryManager.ARCHAIC_CIRCUIT.get());
        this.basicItem((Item)RegistryManager.SUPERHEATER.get());
        this.basicItem((Item)RegistryManager.CINDER_JET.get());
        this.basicItem((Item)RegistryManager.BLASTING_CORE.get());
        this.basicItem((Item)RegistryManager.CASTER_ORB.get());
        this.basicItem((Item)RegistryManager.RESONATING_BELL.get());
        this.basicItem((Item)RegistryManager.FLAME_BARRIER.get());
        this.basicItem((Item)RegistryManager.ELDRITCH_INSIGNIA.get());
        this.basicItem((Item)RegistryManager.INTELLIGENT_APPARATUS.get());
        this.basicItem((Item)RegistryManager.DIFFRACTION_BARREL.get());
        this.basicItem((Item)RegistryManager.FOCAL_LENS.get());
        this.basicItem((Item)RegistryManager.SHIFTING_SCALES.get());
        this.basicItem((Item)RegistryManager.WINDING_GEARS.get());
        this.itemWithTexture(RegistryManager.RAW_CAMINITE_PLATE, "plate_caminite_raw");
        this.itemWithTexture(RegistryManager.RAW_FLAT_STAMP, "flat_stamp_raw");
        this.itemWithTexture(RegistryManager.RAW_INGOT_STAMP, "ingot_stamp_raw");
        this.itemWithTexture(RegistryManager.RAW_NUGGET_STAMP, "nugget_stamp_raw");
        this.itemWithTexture(RegistryManager.RAW_PLATE_STAMP, "plate_stamp_raw");
        this.itemWithTexture(RegistryManager.RAW_GEAR_STAMP, "gear_stamp_raw");
        this.itemWithTexture(RegistryManager.CAMINITE_PLATE, "plate_caminite");
        this.basicItem((Item)RegistryManager.FLAT_STAMP.get());
        this.basicItem((Item)RegistryManager.INGOT_STAMP.get());
        this.basicItem((Item)RegistryManager.NUGGET_STAMP.get());
        this.basicItem((Item)RegistryManager.PLATE_STAMP.get());
        this.basicItem((Item)RegistryManager.GEAR_STAMP.get());
        this.itemWithTexture(RegistryManager.IRON_ASPECTUS, "aspectus_iron");
        this.itemWithTexture(RegistryManager.COPPER_ASPECTUS, "aspectus_copper");
        this.itemWithTexture(RegistryManager.LEAD_ASPECTUS, "aspectus_lead");
        this.itemWithTexture(RegistryManager.SILVER_ASPECTUS, "aspectus_silver");
        this.itemWithTexture(RegistryManager.DAWNSTONE_ASPECTUS, "aspectus_dawnstone");
        this.itemWithTexture(RegistryManager.IRON_PLATE, "plate_iron");
        this.itemWithTexture(RegistryManager.COPPER_PLATE, "plate_copper");
        this.itemWithTexture(RegistryManager.COPPER_NUGGET, "nugget_copper");
        this.basicItem((Item)RegistryManager.RAW_LEAD.get());
        this.itemWithTexture(RegistryManager.LEAD_INGOT, "ingot_lead");
        this.itemWithTexture(RegistryManager.LEAD_NUGGET, "nugget_lead");
        this.itemWithTexture(RegistryManager.LEAD_PLATE, "plate_lead");
        this.basicItem((Item)RegistryManager.RAW_SILVER.get());
        this.itemWithTexture(RegistryManager.SILVER_INGOT, "ingot_silver");
        this.itemWithTexture(RegistryManager.SILVER_NUGGET, "nugget_silver");
        this.itemWithTexture(RegistryManager.SILVER_PLATE, "plate_silver");
        this.itemWithTexture(RegistryManager.DAWNSTONE_INGOT, "ingot_dawnstone");
        this.itemWithTexture(RegistryManager.DAWNSTONE_NUGGET, "nugget_dawnstone");
        this.itemWithTexture(RegistryManager.DAWNSTONE_PLATE, "plate_dawnstone");
        this.toolModels(RegistryManager.LEAD_TOOLS);
        this.toolModels(RegistryManager.SILVER_TOOLS);
        this.toolModels(RegistryManager.DAWNSTONE_TOOLS);
        this.basicItem((Item)CuriosCompat.EMBER_RING.get());
        this.basicItem((Item)CuriosCompat.EMBER_BELT.get());
        this.basicItem((Item)CuriosCompat.EMBER_AMULET.get());
        this.basicItem((Item)CuriosCompat.DAWNSTONE_MAIL.get());
        this.basicItem((Item)CuriosCompat.ASHEN_AMULET.get());
        this.basicItem((Item)CuriosCompat.NONBELEIVER_AMULET.get());
        this.basicItem((Item)CuriosCompat.EXPLOSION_CHARM.get());
        this.spawnEgg(RegistryManager.ANCIENT_GOLEM_SPAWN_EGG);
        this.buttonInventory(RegistryManager.CAMINITE_BUTTON_ITEM.getId().m_135815_(), new ResourceLocation("embers", "block/caminite_button"));
    }

    public void itemWithModel(RegistryObject<? extends Item> registryObject, String model) {
        ResourceLocation id = registryObject.getId();
        ResourceLocation textureLocation = new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_());
        this.singleTexture(id.m_135815_(), new ResourceLocation(model), "layer0", textureLocation);
    }

    public void spawnEgg(RegistryObject<? extends Item> registryObject) {
        this.withExistingParent(registryObject.getId().m_135815_(), "item/template_spawn_egg");
    }

    public void itemWithTexture(RegistryObject<? extends Item> registryObject, String texture) {
        this.itemWithTexture(registryObject, "item/generated", texture);
    }

    public void itemWithTexture(RegistryObject<? extends Item> registryObject, String model, String texture) {
        ResourceLocation id = registryObject.getId();
        ResourceLocation textureLocation = new ResourceLocation(id.m_135827_(), "item/" + texture);
        this.singleTexture(id.m_135815_(), new ResourceLocation(model), "layer0", textureLocation);
    }

    public void layeredItem(RegistryObject<? extends Item> registryObject, String model, String ... textures) {
        ResourceLocation id = registryObject.getId();
        ModelBuilder builder = this.withExistingParent(id.m_135815_(), new ResourceLocation(model));
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, new ResourceLocation(id.m_135827_(), "item/" + textures[i]));
        }
    }

    public void bucketModel(RegistryObject<? extends BucketItem> registryObject, Fluid fluid) {
        ModelBuilder builder = this.withExistingParent(registryObject.getId().m_135815_(), new ResourceLocation("embers", "item/bucket_fluid"));
        ((DynamicFluidContainerModelBuilder)builder.customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluid).coverIsMask(false).flipGas(true).end();
    }

    public void toolModels(RegistryManager.ToolSet set) {
        this.itemWithTexture(set.SWORD, "item/handheld", "sword_" + set.name);
        this.itemWithTexture(set.SHOVEL, "item/handheld", "shovel_" + set.name);
        this.itemWithTexture(set.PICKAXE, "item/handheld", "pickaxe_" + set.name);
        this.itemWithTexture(set.AXE, "item/handheld", "axe_" + set.name);
        this.itemWithTexture(set.HOE, "item/handheld", "hoe_" + set.name);
    }
}

