/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.entity;

import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.api.projectile.IProjectileEffect;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.util.EmbersColors;
import com.rekindled.embers.util.Misc;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Vector3f;

public class EmberProjectileEntity
extends Projectile {
    public static final EntityDataAccessor<Float> value = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> dead = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> lifetime = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> color = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> colorId = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public IProjectileEffect effect;
    private IProjectilePreset preset;
    double gravity;
    int homingTime;
    double homingRange;
    int homingIndex;
    int homingModulo;
    Entity homingTarget;
    Predicate<Entity> homingPredicate;

    public EmberProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(value, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(dead, (Object)false);
        this.m_20088_().m_135372_(lifetime, (Object)160);
        this.m_20088_().m_135372_(color, (Object)Misc.intColor(EmbersColors.EMBER));
        this.m_20088_().m_135372_(colorId, (Object)EmbersColors.EMBER_ID.toString());
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy, double value) {
        this.f_19815_ = EntityDimensions.m_20395_((float)((float)value / 10.0f), (float)((float)value / 10.0f));
        this.m_20088_().m_135381_(EmberProjectileEntity.value, (Object)Float.valueOf((float)value));
        this.m_5602_(shooter);
        super.m_6686_((double)x, (double)y, (double)z, velocity, inaccuracy);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy, double value) {
        this.f_19815_ = EntityDimensions.m_20395_((float)((float)value / 10.0f), (float)((float)value / 10.0f));
        this.m_20088_().m_135381_(EmberProjectileEntity.value, (Object)Float.valueOf((float)value));
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public void setColor(int colour) {
        this.m_20088_().m_135381_(color, (Object)colour);
        this.m_20088_().m_135381_(colorId, (Object)EmbersColors.CUSTOM_ID.toString());
    }

    public void setColor(Vector3f colour) {
        this.setColor(Misc.intColor(colour));
    }

    public void setColor(ResourceLocation color) {
        this.m_20088_().m_135381_(colorId, (Object)color.toString());
    }

    public void setHoming(int time, double range, int index, int modulo, Predicate<Entity> predicate) {
        this.homingTime = time;
        this.homingRange = range;
        this.homingIndex = index;
        this.homingModulo = modulo;
        this.homingPredicate = predicate;
    }

    public void setPreset(IProjectilePreset preset) {
        this.preset = preset;
    }

    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public void setLifetime(int lifetime) {
        this.m_20088_().m_135381_(EmberProjectileEntity.lifetime, (Object)lifetime);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.m_20088_().m_135381_(value, (Object)Float.valueOf(nbt.m_128457_("value")));
        this.m_20088_().m_135381_(color, (Object)nbt.m_128451_("color"));
        this.m_20088_().m_135381_(colorId, (Object)nbt.m_128461_("colorId"));
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128350_("value", ((Float)this.m_20088_().m_135370_(value)).floatValue());
        nbt.m_128405_("color", ((Integer)this.m_20088_().m_135370_(color)).intValue());
        nbt.m_128359_("colorId", (String)this.m_20088_().m_135370_(colorId));
    }

    public void m_8119_() {
        super.m_8119_();
        int lifetime = (Integer)this.m_20088_().m_135370_(EmberProjectileEntity.lifetime);
        this.m_20088_().m_135381_(EmberProjectileEntity.lifetime, (Object)(lifetime - 1));
        if (lifetime <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!((Boolean)this.m_20088_().m_135370_(dead)).booleanValue()) {
            EntityHitResult hitEntity;
            this.m_20088_().m_135381_(value, (Object)Float.valueOf(((Float)this.m_20088_().m_135370_(value)).floatValue() - 0.025f));
            if (((Float)this.m_20088_().m_135370_(value)).floatValue() <= 0.0f) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            Vec3 currPosVec = this.m_20182_();
            Vec3 newPosVector = currPosVec.m_82549_(this.m_20184_());
            BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(currPosVec, newPosVector.m_82549_(this.m_20184_().m_82541_().m_82490_(1.5)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
                newPosVector = raytraceresult.m_82450_();
            }
            if ((hitEntity = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)currPosVec, (Vec3)newPosVector, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), x$0 -> this.m_5603_((Entity)x$0))) != null) {
                raytraceresult = hitEntity;
            }
            this.m_6478_(MoverType.SELF, newPosVector.m_82546_(currPosVec));
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.gravity, 0.0));
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_((HitResult)raytraceresult);
            }
            this.handleHoming(lifetime, this.m_9236_());
            if (this.m_9236_().m_5776_()) {
                double deltaX = this.m_20185_() - currPosVec.f_82479_;
                double deltaY = this.m_20186_() - currPosVec.f_82480_;
                double deltaZ = this.m_20189_() - currPosVec.f_82481_;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 10.0);
                GlowParticleOptions options = new GlowParticleOptions(EmbersAPI.getColor(new ResourceLocation((String)this.m_20088_().m_135370_(colorId)), Misc.colorFromInt((Integer)this.m_20088_().m_135370_(color))), ((Float)this.m_20088_().m_135370_(value)).floatValue() / 1.75f, 24);
                for (double i = 0.0; i < dist; i += 1.0) {
                    double coeff = i / dist;
                    this.m_9236_().m_6485_((ParticleOptions)options, true, currPosVec.f_82479_ + deltaX * coeff, currPosVec.f_82480_ + deltaY * coeff, currPosVec.f_82481_ + deltaZ * coeff, (double)(0.125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.125f * (this.f_19796_.m_188501_() - 0.5f)));
                }
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
    }

    private void handleHoming(int lifetime, Level world) {
        if (this.homingTime > 0) {
            if (!this.isTargetInvalid(this.homingTarget)) {
                double targetX = this.homingTarget.m_20185_();
                double targetY = this.homingTarget.m_20186_() + (double)(this.homingTarget.m_20206_() / 2.0f);
                double targetZ = this.homingTarget.m_20189_();
                Vec3 targetVector = new Vec3(targetX - this.m_20185_(), targetY - this.m_20186_(), targetZ - this.m_20189_());
                double length = targetVector.m_82553_();
                targetVector = targetVector.m_82490_(0.3 / length);
                double weight = 0.0;
                if (length <= this.homingRange) {
                    weight = 0.9 * ((this.homingRange - length) / this.homingRange);
                }
                Vec3 delta = this.m_20184_();
                this.m_20334_((0.9 - weight) * delta.f_82479_ + (0.1 + weight) * targetVector.f_82479_, (0.9 - weight) * delta.f_82480_ + (0.1 + weight) * targetVector.f_82480_, (0.9 - weight) * delta.f_82481_ + (0.1 + weight) * targetVector.f_82481_);
                --this.homingTime;
            } else if (lifetime % 5 == 0) {
                AABB homingAABB = new AABB(this.m_20185_() - this.homingRange, this.m_20186_() - this.homingRange, this.m_20189_() - this.homingRange, this.m_20185_() + this.homingRange, this.m_20186_() + this.homingRange, this.m_20189_() + this.homingRange);
                List entities = world.m_6249_((Entity)this, homingAABB, this.homingPredicate);
                Entity badTarget = null;
                for (Entity entity : entities) {
                    long leastSignificantBits = entity.m_20148_().getLeastSignificantBits() & 0xFFFFL;
                    if (leastSignificantBits % (long)this.homingModulo == (long)(this.homingIndex % this.homingModulo)) {
                        this.homingTarget = entity;
                    }
                    badTarget = entity;
                }
                if (this.homingTarget == null) {
                    this.homingTarget = badTarget;
                }
            }
        }
    }

    private boolean isTargetInvalid(Entity entity) {
        return entity == null || entity.m_213877_();
    }

    public void m_6532_(HitResult raytraceresult) {
        super.m_6532_(raytraceresult);
        if (this.m_9236_().m_5776_()) {
            GlowParticleOptions options = new GlowParticleOptions(EmbersAPI.getColor(new ResourceLocation((String)this.m_20088_().m_135370_(colorId)), Misc.colorFromInt((Integer)this.m_20088_().m_135370_(color))), ((Float)this.m_20088_().m_135370_(value)).floatValue(), 24);
            float dist = ((Float)this.m_20088_().m_135370_(value)).floatValue() * 0.25f;
            for (double i = 0.0; i < 40.0; i += 1.0) {
                this.m_9236_().m_6485_((ParticleOptions)options, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)(dist * (this.f_19796_.m_188501_() - 0.5f)), (double)(dist * (this.f_19796_.m_188501_() - 0.5f)), (double)(dist * (this.f_19796_.m_188501_() - 0.5f)));
            }
        } else {
            this.m_216990_((double)((Float)this.m_20088_().m_135370_(value)).floatValue() > 7.0 ? (SoundEvent)EmbersSounds.FIREBALL_BIG_HIT.get() : (SoundEvent)EmbersSounds.FIREBALL_HIT.get());
            this.m_20088_().m_135381_(lifetime, (Object)20);
            this.m_20088_().m_135381_(dead, (Object)true);
            this.m_20256_(Vec3.f_82478_);
            if (this.effect != null) {
                this.effect.onHit(this.m_9236_(), raytraceresult, this.preset);
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

