/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.network.message;

import com.rekindled.embers.api.tile.IDialEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageDialUpdateRequest {
    public long pos = 0L;
    public int maxLines;

    public MessageDialUpdateRequest(long pos, int maxLines) {
        this.pos = pos;
        this.maxLines = maxLines;
    }

    public MessageDialUpdateRequest(BlockPos pos, int maxLines) {
        this.pos = pos.m_121878_();
        this.maxLines = maxLines;
    }

    public static void encode(MessageDialUpdateRequest msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.pos);
        buf.writeInt(msg.maxLines);
    }

    public static MessageDialUpdateRequest decode(FriendlyByteBuf buf) {
        return new MessageDialUpdateRequest(buf.readLong(), buf.readInt());
    }

    public static void handle(MessageDialUpdateRequest msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                IDialEntity dial;
                Packet<ClientGamePacketListener> packet;
                BlockEntity blockEntity;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && player.m_9236_() != null && (blockEntity = player.m_9236_().m_7702_(BlockPos.m_122022_((long)msg.pos))) instanceof IDialEntity && (packet = (dial = (IDialEntity)blockEntity).getUpdatePacket(msg.maxLines)) != null) {
                    player.f_8906_.m_9829_(packet);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

