/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.BoringRecipe;
import com.rekindled.embers.util.WeightedItemStack;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BoringRecipeBuilder {
    public ResourceLocation id;
    public ItemStack result;
    public int weight = 20;
    public int minHeight = Integer.MIN_VALUE;
    public int maxHeight = Integer.MAX_VALUE;
    public HashSet<ResourceLocation> dimensions = new HashSet();
    public HashSet<ResourceLocation> biomes = new HashSet();
    public TagKey<Block> requiredBlock = null;
    public int amountRequired = 0;
    public double chance = -1.0;
    public RecipeSerializer<?> type = (RecipeSerializer)RegistryManager.BORING_SERIALIZER.get();

    public static BoringRecipeBuilder create(ItemStack itemStack) {
        BoringRecipeBuilder builder = new BoringRecipeBuilder();
        builder.result = itemStack;
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static BoringRecipeBuilder create(Item item) {
        return BoringRecipeBuilder.create(new ItemStack((ItemLike)item));
    }

    public BoringRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public BoringRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public BoringRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public BoringRecipeBuilder type(RecipeSerializer<?> type) {
        this.type = type;
        return this;
    }

    public BoringRecipeBuilder weight(int weight) {
        this.weight = weight;
        return this;
    }

    public BoringRecipeBuilder minHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public BoringRecipeBuilder maxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public BoringRecipeBuilder dimensions(HashSet<ResourceLocation> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public BoringRecipeBuilder biomes(HashSet<ResourceLocation> biomes) {
        this.biomes = biomes;
        return this;
    }

    public BoringRecipeBuilder dimension(ResourceLocation ... dimensions) {
        for (ResourceLocation dimension : dimensions) {
            this.dimensions.add(dimension);
        }
        return this;
    }

    public BoringRecipeBuilder biome(ResourceLocation ... biomes) {
        for (ResourceLocation biome : biomes) {
            this.biomes.add(biome);
        }
        return this;
    }

    public BoringRecipeBuilder require(TagKey<Block> requiredBlock, int amountRequired) {
        this.requiredBlock = requiredBlock;
        this.amountRequired = amountRequired;
        return this;
    }

    public BoringRecipeBuilder chance(double chance) {
        this.chance = chance;
        return this;
    }

    public BoringRecipe build() {
        return new BoringRecipe(this.id, new WeightedItemStack(this.result, this.weight), this.minHeight, this.maxHeight, this.dimensions, this.biomes, this.requiredBlock, this.amountRequired, this.chance);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build(), this.type));
    }

    public static class Finished
    implements FinishedRecipe {
        public final BoringRecipe recipe;
        public final RecipeSerializer<?> type;

        public Finished(BoringRecipe recipe, RecipeSerializer<?> type) {
            this.recipe = recipe;
            this.type = type;
        }

        public void m_7917_(JsonObject json) {
            if (this.recipe.minHeight != Integer.MIN_VALUE) {
                json.addProperty("min_height", (Number)this.recipe.minHeight);
            }
            if (this.recipe.minHeight != Integer.MAX_VALUE) {
                json.addProperty("max_height", (Number)this.recipe.maxHeight);
            }
            if (!this.recipe.dimensions.isEmpty()) {
                JsonArray dimJson = new JsonArray();
                for (ResourceLocation dimension : this.recipe.dimensions) {
                    dimJson.add(dimension.toString());
                }
                json.add("dimensions", (JsonElement)dimJson);
            }
            if (!this.recipe.biomes.isEmpty()) {
                JsonArray biomeJson = new JsonArray();
                for (ResourceLocation biome : this.recipe.biomes) {
                    biomeJson.add(biome.toString());
                }
                json.add("biomes", (JsonElement)biomeJson);
            }
            if (this.recipe.amountRequired != 0) {
                JsonObject blockJson = new JsonObject();
                blockJson.addProperty("block_tag", this.recipe.requiredBlock.f_203868_().toString());
                blockJson.addProperty("amount", (Number)this.recipe.amountRequired);
                json.add("required_block", (JsonElement)blockJson);
            }
            if (this.recipe.chance != -1.0) {
                json.addProperty("chance", (Number)this.recipe.chance);
            }
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.recipe.result.getStack().m_41720_()).toString());
            int count = this.recipe.result.getStack().m_41613_();
            if (count > 1) {
                resultJson.addProperty("count", (Number)count);
            }
            json.add("output", (JsonElement)resultJson);
            json.addProperty("weight", (Number)this.recipe.result.m_142631_().m_146281_());
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

