/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.recipe.CatalysisCombustionContext;
import com.rekindled.embers.recipe.ICatalysisCombustionRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CatalysisCombustionRecipe
implements ICatalysisCombustionRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final Ingredient machine;
    public final int burnTime;
    public final double multiplier;

    public CatalysisCombustionRecipe(ResourceLocation id, Ingredient ingredient, Ingredient machine, int burnTime, double multiplier) {
        this.id = id;
        this.ingredient = ingredient;
        this.machine = machine;
        this.burnTime = burnTime;
        this.multiplier = multiplier;
    }

    public boolean matches(CatalysisCombustionContext context, Level pLevel) {
        if (this.machine.test(context.machine)) {
            for (int i = 0; i < context.m_6643_(); ++i) {
                if (!this.ingredient.test(context.m_8020_(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getBurnTIme(CatalysisCombustionContext context) {
        return this.burnTime;
    }

    @Override
    public double getmultiplier(CatalysisCombustionContext context) {
        return this.multiplier;
    }

    @Override
    public int process(CatalysisCombustionContext context) {
        for (int i = 0; i < context.m_6643_(); ++i) {
            if (!this.ingredient.test(context.m_8020_(i))) continue;
            context.m_7407_(i, 1);
            break;
        }
        return this.burnTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public Ingredient getDisplayInput() {
        return this.ingredient;
    }

    @Override
    public Ingredient getDisplayMachine() {
        return this.machine;
    }

    @Override
    public int getDisplayTime() {
        return this.burnTime;
    }

    @Override
    public double getDisplayMultiplier() {
        return this.multiplier;
    }

    public static class Serializer
    implements RecipeSerializer<CatalysisCombustionRecipe> {
        public CatalysisCombustionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("input"));
            Ingredient machine = Ingredient.m_43917_((JsonElement)json.get("machine"));
            int burnTime = GsonHelper.m_13927_((JsonObject)json, (String)"burn_time");
            double multiplier = GsonHelper.m_144784_((JsonObject)json, (String)"multiplier");
            return new CatalysisCombustionRecipe(recipeId, ingredient, machine, burnTime, multiplier);
        }

        @Nullable
        public CatalysisCombustionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient machine = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int burnTime = buffer.m_130242_();
            double multiplier = buffer.readDouble();
            return new CatalysisCombustionRecipe(recipeId, ingredient, machine, burnTime, multiplier);
        }

        public void toNetwork(FriendlyByteBuf buffer, CatalysisCombustionRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            recipe.machine.m_43923_(buffer);
            buffer.m_130130_(recipe.burnTime);
            buffer.writeDouble(recipe.multiplier);
        }
    }
}

