/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.worldgen.CaveStructurePiece;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class CaveStructure
extends Structure {
    public static final Codec<CaveStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)CaveStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)HeightProvider.f_161970_.optionalFieldOf("max_height", (Object)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158929_())).forGetter(structure -> structure.maxHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, CaveStructure::new)), CaveStructure::verifyRange).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final HeightProvider maxHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    static final Logger LOGGER = LogUtils.getLogger();

    public static DataResult<CaveStructure> verifyRange(CaveStructure structure) {
        int i = switch (structure.m_226620_()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return structure.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    protected CaveStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, HeightProvider maxHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.maxHeight = maxHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public CaveStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, HeightProvider maxHeight, boolean useExpansionHack, Heightmap.Types projectStartToHeightmap) {
        this(settings, startPool, Optional.empty(), maxDepth, startHeight, maxHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 80);
    }

    public CaveStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, HeightProvider maxHeight, boolean useExpansionHack) {
        this(settings, startPool, Optional.empty(), maxDepth, startHeight, maxHeight, useExpansionHack, Optional.empty(), 80);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        int max = this.maxHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), i, chunkpos.m_45605_());
        return CaveStructure.addPieces(context, this.startPool, this.startJigsawName, this.maxDepth, blockpos, max, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)RegistryManager.CAVE_STRUCTURE.get();
    }

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext pContext, Holder<StructureTemplatePool> pStartPool, Optional<ResourceLocation> pStartJigsawName, int pMaxDepth, BlockPos pPos, int maxHeight, boolean pUseExpansionHack, Optional<Heightmap.Types> pProjectStartToHeightmap, int pMaxDistanceFromCenter) {
        BlockPos blockpos;
        RegistryAccess registryaccess = pContext.f_226621_();
        ChunkGenerator chunkgenerator = pContext.f_226622_();
        StructureTemplateManager structuretemplatemanager = pContext.f_226625_();
        LevelHeightAccessor levelheightaccessor = pContext.f_226629_();
        WorldgenRandom worldgenrandom = pContext.f_226626_();
        Registry registry = registryaccess.m_175515_(Registries.f_256948_);
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)pStartPool.m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_227355_((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (pStartJigsawName.isPresent()) {
            ResourceLocation resourcelocation = pStartJigsawName.get();
            Optional optional = JigsawPlacement.m_227247_((StructurePoolElement)structurepoolelement, (ResourceLocation)resourcelocation, (BlockPos)pPos, (Rotation)rotation, (StructureTemplateManager)structuretemplatemanager, (WorldgenRandom)worldgenrandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)pStartPool.m_203543_().map(p_248484_ -> p_248484_.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockpos = (BlockPos)optional.get();
        } else {
            blockpos = pPos;
        }
        BlockPos vec3i = blockpos.m_121996_((Vec3i)pPos);
        BlockPos blockpos1 = pPos.m_121996_((Vec3i)vec3i);
        CaveStructurePiece poolelementstructurepiece = new CaveStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_214015_(structuretemplatemanager, blockpos1, rotation), pContext, maxHeight);
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = pProjectStartToHeightmap.isPresent() ? pPos.m_123342_() + chunkgenerator.m_223221_(i, j, pProjectStartToHeightmap.get(), levelheightaccessor, pContext.f_226624_()) : blockpos1.m_123342_();
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        int i1 = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), p_227237_ -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (pMaxDepth > 0) {
                AABB aabb = new AABB((double)(i - pMaxDistanceFromCenter), (double)(i1 - pMaxDistanceFromCenter), (double)(j - pMaxDistanceFromCenter), (double)(i + pMaxDistanceFromCenter + 1), (double)(i1 + pMaxDistanceFromCenter + 1), (double)(j + pMaxDistanceFromCenter + 1));
                VoxelShape voxelshape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_);
                JigsawPlacement.m_227210_((RandomState)pContext.f_226624_(), (int)pMaxDepth, (boolean)pUseExpansionHack, (ChunkGenerator)chunkgenerator, (StructureTemplateManager)structuretemplatemanager, (LevelHeightAccessor)levelheightaccessor, (RandomSource)worldgenrandom, (Registry)registry, (PoolElementStructurePiece)poolelementstructurepiece, (List)list, (VoxelShape)voxelshape);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_227237_).m_142679_(arg_0));
            }
        }));
    }
}

