/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.road;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class CurveUtil {
    public static List<BlockPos> sampleCatmullRomBlocks(List<BlockPos> pts) {
        List<Vec3> vecs = CurveUtil.sampleCatmullRomVec(pts);
        LinkedHashSet<BlockPos> unique = new LinkedHashSet<BlockPos>();
        for (Vec3 v : vecs) {
            unique.add(new BlockPos((int)Math.round(v.x), (int)Math.round(v.y), (int)Math.round(v.z)));
        }
        return new ArrayList<BlockPos>(unique);
    }

    public static List<Vec3> sampleCatmullRomVec(List<BlockPos> pts) {
        ArrayList<Vec3> out = new ArrayList<Vec3>();
        if (pts == null || pts.size() == 0) {
            return out;
        }
        if (pts.size() == 1) {
            BlockPos p = pts.get(0);
            out.add(CurveUtil.centerOf(p));
            return out;
        }
        if (pts.size() == 2) {
            Vec3 v1 = CurveUtil.centerOf(pts.get(0));
            Vec3 v2 = CurveUtil.centerOf(pts.get(1));
            double dist = v1.distanceTo(v2);
            int steps = Math.max(20, (int)(dist * 3.0));
            for (int s = 0; s <= steps; ++s) {
                double t = (double)s / (double)steps;
                Vec3 v = CurveUtil.lerp(v1, v2, t);
                out.add(v);
            }
            return out;
        }
        int n = pts.size();
        for (int i = 0; i < n - 1; ++i) {
            Vec3 p3;
            Vec3 p0;
            Vec3 p1 = CurveUtil.centerOf(pts.get(i));
            Vec3 p2 = CurveUtil.centerOf(pts.get(i + 1));
            if (i == 0) {
                Vec3 dir = p2.subtract(p1);
                p0 = p1.subtract(dir.scale(0.5));
            } else {
                p0 = CurveUtil.centerOf(pts.get(i - 1));
            }
            if (i >= n - 2) {
                Vec3 dir = p2.subtract(p1);
                p3 = p2.add(dir.scale(0.5));
            } else {
                p3 = CurveUtil.centerOf(pts.get(i + 2));
            }
            double segLen = p1.distanceTo(p2);
            int steps = Math.max(20, (int)(segLen * 3.0));
            for (int s = 0; s <= steps; ++s) {
                double t = (double)s / (double)steps;
                Vec3 v = CurveUtil.catmullRomUniform(p0, p1, p2, p3, t);
                out.add(v);
            }
        }
        return out;
    }

    private static Vec3 lerp(Vec3 a, Vec3 b, double t) {
        return new Vec3(a.x + (b.x - a.x) * t, a.y + (b.y - a.y) * t, a.z + (b.z - a.z) * t);
    }

    private static Vec3 catmullRomUniform(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double x = 0.5 * (2.0 * p1.x + (-p0.x + p2.x) * t + (2.0 * p0.x - 5.0 * p1.x + 4.0 * p2.x - p3.x) * t2 + (-p0.x + 3.0 * p1.x - 3.0 * p2.x + p3.x) * t3);
        double y = 0.5 * (2.0 * p1.y + (-p0.y + p2.y) * t + (2.0 * p0.y - 5.0 * p1.y + 4.0 * p2.y - p3.y) * t2 + (-p0.y + 3.0 * p1.y - 3.0 * p2.y + p3.y) * t3);
        double z = 0.5 * (2.0 * p1.z + (-p0.z + p2.z) * t + (2.0 * p0.z - 5.0 * p1.z + 4.0 * p2.z - p3.z) * t2 + (-p0.z + 3.0 * p1.z - 3.0 * p2.z + p3.z) * t3);
        return new Vec3(x, y, z);
    }

    private static Vec3 centerOf(BlockPos p) {
        return new Vec3((double)p.getX() + 0.5, (double)p.getY(), (double)p.getZ() + 0.5);
    }
}

