/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import com.mojang.serialization.MapCodec;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlockEntities;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AsphaltBlock
extends BaseEntityBlock {
    public static final MapCodec<AsphaltBlock> CODEC = AsphaltBlock.simpleCodec(p -> new AsphaltBlock((BlockBehaviour.Properties)p));
    public static final Property<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    public static final EnumProperty<TextureVariant> TEXTURE_VARIANT = EnumProperty.create((String)"texture_variant", TextureVariant.class);

    public AsphaltBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_BLACK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(VARIANT, (Comparable)((Object)Variant.DEFAULT))).setValue(TEXTURE_VARIANT, (Comparable)((Object)TextureVariant.DEFAULT)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)SarosRoadBlocksModModBlockEntities.ROAD_BLOCK_ENTITY.get()).create(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int height = this.getHeightForVariant((Variant)((Object)state.getValue(VARIANT)));
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> AsphaltBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.EAST -> AsphaltBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.WEST -> AsphaltBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            default -> AsphaltBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        };
    }

    private int getHeightForVariant(Variant variant) {
        return switch (variant.ordinal()) {
            case 1 -> 15;
            case 2 -> 14;
            case 3 -> 13;
            case 4 -> 12;
            case 5 -> 11;
            case 6 -> 10;
            case 7 -> 9;
            case 8 -> 8;
            case 9 -> 7;
            case 10 -> 6;
            case 11 -> 5;
            case 12 -> 4;
            case 13 -> 3;
            case 14 -> 2;
            case 15 -> 1;
            default -> 16;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT, TEXTURE_VARIANT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(VARIANT, (Comparable)((Object)Variant.DEFAULT))).setValue(TEXTURE_VARIANT, (Comparable)((Object)TextureVariant.DEFAULT));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.rotate(state, mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT("default"),
        ONE("1"),
        TWO("2"),
        THREE("3"),
        FOUR("4"),
        FIVE("5"),
        SIX("6"),
        SEVEN("7"),
        EIGHT("8"),
        NINE("9"),
        TEN("10"),
        ELEVEN("11"),
        TWELVE("12"),
        THIRTEEN("13"),
        FOURTEEN("14"),
        FIFTEEN("15");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum TextureVariant implements StringRepresentable
    {
        DEFAULT("default"),
        STRAIGHT("straight"),
        CORNER("corner"),
        CROSS("cross"),
        TWO("two"),
        TT("tt"),
        TF("tf"),
        TS("ts"),
        TSE("tse"),
        TE("te"),
        NT("nt"),
        THIRTY("thirty"),
        OHAE("ohae"),
        OHAT("ohat"),
        TTA("tta"),
        TTS("tts"),
        TTD("ttd"),
        TTF("ttf"),
        TTG("ttg"),
        TTH("tth"),
        TTJ("ttj"),
        TTK("ttk"),
        ARROW("arrow"),
        ROAD_BLOCK_LINIE_CROSS_YELLOW("road_block_linie_cross_yellow"),
        ROAD_BLOCK_LINIE_ECKE_YELLOW("road_block_linie_ecke_yellow"),
        ROAD_BLOCK_LINIE_GRAD_ECK_YELLOW("road_block_linie_grad_eck_yellow"),
        ROAD_BLOCK_LINIE_YELLOW("road_block_linie_yellow"),
        ECKE_WHITE("ecke_white"),
        CORNER_STRAIGHT("corner_straight");

        private final String name;

        private TextureVariant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

