/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.entity.RoadBlockEntity;
import de.sarocesch.sarosroadblocksmod.client.renderer.RoadBlockRenderState;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RoadBlockRenderer
implements BlockEntityRenderer<RoadBlockEntity, RoadBlockRenderState> {
    public RoadBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public RoadBlockRenderState createRenderState() {
        return new RoadBlockRenderState();
    }

    public void extractRenderState(RoadBlockEntity be, RoadBlockRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        int height16;
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)renderState, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        BlockState blockState = be.getBlockState();
        if (!(blockState.getBlock() instanceof AsphaltBlock)) {
            return;
        }
        if (blockState.getValue(AsphaltBlock.TEXTURE_VARIANT) != AsphaltBlock.TextureVariant.DEFAULT) {
            return;
        }
        String textureId = be.getTextureId();
        if (textureId == null || textureId.isEmpty() || "default".equals(textureId)) {
            return;
        }
        RoadTextureManager mgr = RoadTextureManager.getInstance();
        RoadTextureManager.TextureSet set = mgr.getTextureSet(textureId);
        if (set == null || set.top == null) {
            return;
        }
        renderState.textureId = textureId;
        renderState.facing = (Direction)blockState.getValue(AsphaltBlock.FACING);
        renderState.variantName = ((AsphaltBlock.Variant)((Object)blockState.getValue(AsphaltBlock.VARIANT))).getSerializedName();
        renderState.height16 = height16 = "default".equals(renderState.variantName) ? 16 : Math.max(1, 16 - this.parseIntSafe(renderState.variantName, 0));
        renderState.packedLight = be.getLevel() != null ? be.getLevel().getBrightness(LightLayer.BLOCK, be.getBlockPos()) : 15;
    }

    public void submit(RoadBlockRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.textureId == null) {
            return;
        }
        RoadTextureManager mgr = RoadTextureManager.getInstance();
        RoadTextureManager.TextureSet set = mgr.getTextureSet(renderState.textureId);
        if (set == null || set.top == null) {
            return;
        }
        float y = (float)renderState.height16 / 16.0f + 0.001f;
        int packedLight = renderState.packedLight;
        int rotY = switch (renderState.facing) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotY));
        poseStack.translate(-0.5, 0.0, -0.5);
        ResourceLocation topTexture = set.top;
        float finalY = y;
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)topTexture), (pose, vertexConsumer) -> this.renderQuadTop(pose, vertexConsumer, finalY, packedLight));
        ResourceLocation north = mgr.getFaceTexture(renderState.textureId, RoadTextureManager.Face.NORTH);
        ResourceLocation south = mgr.getFaceTexture(renderState.textureId, RoadTextureManager.Face.SOUTH);
        ResourceLocation east = mgr.getFaceTexture(renderState.textureId, RoadTextureManager.Face.EAST);
        ResourceLocation west = mgr.getFaceTexture(renderState.textureId, RoadTextureManager.Face.WEST);
        float y0 = 0.0f;
        float y1 = (float)renderState.height16 / 16.0f;
        float eps = 0.001f;
        if (north != null) {
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)north), (pose, vertexConsumer) -> this.renderQuadNorth(pose, vertexConsumer, y0, y1, eps, packedLight));
        }
        if (south != null) {
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)south), (pose, vertexConsumer) -> this.renderQuadSouth(pose, vertexConsumer, y0, y1, eps, packedLight));
        }
        if (east != null) {
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)east), (pose, vertexConsumer) -> this.renderQuadEast(pose, vertexConsumer, y0, y1, eps, packedLight));
        }
        if (west != null) {
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)west), (pose, vertexConsumer) -> this.renderQuadWest(pose, vertexConsumer, y0, y1, eps, packedLight));
        }
        poseStack.popPose();
    }

    private int parseIntSafe(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private void renderQuadTop(PoseStack.Pose pose, VertexConsumer vc, float y, int light) {
        Matrix4f m = pose.pose();
        vc.addVertex(m, 0.0f, y, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 1.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 0.0f, y, 1.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
    }

    private void renderQuadNorth(PoseStack.Pose pose, VertexConsumer vc, float y0, float y1, float eps, int light) {
        Matrix4f m = pose.pose();
        float z = 0.0f - eps;
        vc.addVertex(m, 0.0f, y0, z).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 1.0f, y0, z).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 1.0f, y1, z).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 0.0f, y1, z).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void renderQuadSouth(PoseStack.Pose pose, VertexConsumer vc, float y0, float y1, float eps, int light) {
        Matrix4f m = pose.pose();
        float z = 1.0f + eps;
        vc.addVertex(m, 1.0f, y0, z).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 0.0f, y0, z).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 0.0f, y1, z).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 1.0f, y1, z).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, 1.0f);
    }

    private void renderQuadEast(PoseStack.Pose pose, VertexConsumer vc, float y0, float y1, float eps, int light) {
        Matrix4f m = pose.pose();
        float x = 1.0f + eps;
        vc.addVertex(m, x, y0, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y0, 1.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 1.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
    }

    private void renderQuadWest(PoseStack.Pose pose, VertexConsumer vc, float y0, float y1, float eps, int light) {
        Matrix4f m = pose.pose();
        float x = 0.0f - eps;
        vc.addVertex(m, x, y0, 1.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y0, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 1.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
    }
}

